/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.generator;

import fluent.api.generator.FixtureBuilder;
import fluent.api.generator.FixtureClass;
import fluent.api.generator.FixtureClassBuilder;
import fluent.api.generator.FixtureClassStaticMethodSender;
import fluent.api.generator.FixtureInterface;
import fluent.api.generator.FixtureInterfaceCreateNameSender;
import fluent.api.generator.FixtureInterfaceMyMethodCaller;
import fluent.api.generator.TestBase;
import fluent.api.generator.impl.FixtureInterfaceCreateBuilderImpl;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ParametersBuilderTest
extends TestBase {
    @Mock
    private FixtureInterface fixtureInterface;
    @Mock
    private List<Double> list;
    private final ZonedDateTime birth = LocalDateTime.now().atZone(ZoneId.systemDefault());

    @Test
    public void testInstanceMethodBuilder() {
        Mockito.when((Object)this.fixtureInterface.createName("a", "b", 5)).thenReturn((Object)1);
        Assert.assertEquals((Object)new FixtureInterfaceCreateNameSender(this.fixtureInterface).prefix("a").suffix("b").padding(5).send(), (Object)1);
        ((FixtureInterface)Mockito.verify((Object)this.fixtureInterface)).createName("a", "b", 5);
    }

    @Test
    public void testStaticMethodBuilder() {
        FixtureClass.fixtureInterface = this.fixtureInterface;
        Assert.assertEquals((Object)new FixtureBuilder().first("a").last("b").age(5).birth(this.birth).build(), (Object)this.birth);
    }

    @Test
    public void testConstructorBuilder() {
        FixtureClass.fixtureInterface = this.fixtureInterface;
        FixtureClass fixtureClass = new FixtureClassBuilder().first("a").last("b").age(5).birth(this.birth).list(this.list).build();
        ((FixtureInterface)Mockito.verify((Object)this.fixtureInterface)).myMethod("a", "b", 5, this.birth, this.list);
        Assert.assertEquals((String)fixtureClass.first, (String)"a");
        Assert.assertEquals((String)fixtureClass.last, (String)"b");
        Assert.assertEquals((int)fixtureClass.age, (int)5);
        Assert.assertEquals((Object)fixtureClass.birth, (Object)this.birth);
    }

    @Test
    public void testInstanceMethodCaller() {
        new FixtureInterfaceMyMethodCaller(this.fixtureInterface).first("a").last("b").age(5).list(this.list).birth(this.birth).call();
        ((FixtureInterface)Mockito.verify((Object)this.fixtureInterface)).myMethod("a", "b", 5, this.birth, this.list);
    }

    @Test
    public void testStaticMethodCaller() {
        FixtureClass.fixtureInterface = this.fixtureInterface;
        new FixtureClassStaticMethodSender().first("a").last("b").age(5).birth(this.birth).list(this.list).send();
        ((FixtureInterface)Mockito.verify((Object)this.fixtureInterface)).myMethod("a", "b", 5, this.birth, this.list);
    }

    @Test
    void testFullParametersBuilder() {
        Mockito.when((Object)this.fixtureInterface.create("a", "b", 5)).thenReturn((Object)"c");
        FixtureInterfaceCreateBuilderImpl builder = new FixtureInterfaceCreateBuilderImpl(this.fixtureInterface);
        Assert.assertEquals((String)builder.age(5).first("a").last("b").build(), (String)"c");
        ((FixtureInterface)Mockito.verify((Object)this.fixtureInterface)).create("a", "b", 5);
    }
}

