/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.generator;

import fluent.api.dsl.impl.FixtureBeanSenderImpl;
import fluent.api.generator.FixtureBean;
import fluent.api.generator.FixtureBeanAccepter;
import fluent.api.generator.FixtureBeanSender;
import fluent.api.generator.FixtureClass;
import fluent.api.generator.FixtureInterface;
import fluent.api.generator.TestBase;
import fluent.api.generator.impl.FixtureSenderImpl;
import java.util.List;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SenderTest
extends TestBase {
    @Mock
    private FixtureBean fixtureBean;
    @Mock
    private FixtureInterface fixtureInterface;
    @Mock
    private List<FixtureBean> list;

    @Test
    public void testSimpleSender() {
        new FixtureBeanAccepter(this.fixtureInterface, this.fixtureBean).firstName("a").accept();
        ((FixtureInterface)Mockito.verify((Object)this.fixtureInterface)).accept(this.fixtureBean);
        ((FixtureBean)Mockito.verify((Object)this.fixtureBean)).setFirstName("a");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fixtureBean});
    }

    @Test
    public void testFullSender() {
        FixtureSenderImpl sender = new FixtureSenderImpl(this.fixtureInterface, this.fixtureBean);
        sender.children(this.list).age(5).send();
        ((FixtureInterface)Mockito.verify((Object)this.fixtureInterface)).accept(this.fixtureBean);
        ((FixtureBean)Mockito.verify((Object)this.fixtureBean)).setAge(5);
        ((FixtureBean)Mockito.verify((Object)this.fixtureBean)).setChildren(this.list);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fixtureBean});
    }

    @Test
    public void testConstructorSender() {
        FixtureClass.fixtureInterface = this.fixtureInterface;
        FixtureClass fixtureClass = new FixtureBeanSender(this.fixtureBean).lastName("a").send();
        ((FixtureBean)Mockito.verify((Object)this.fixtureBean)).setLastName("a");
        ((FixtureBean)Mockito.verify((Object)this.fixtureBean)).getFirstName();
        ((FixtureBean)Mockito.verify((Object)this.fixtureBean)).getLastName();
        ((FixtureBean)Mockito.verify((Object)this.fixtureBean)).getAge();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fixtureBean});
    }

    @Test
    public void testStaticMethodSender() {
        FixtureBeanSenderImpl sender = new FixtureBeanSenderImpl("1", this.fixtureBean);
        Assert.assertEquals((String)sender.age(5).send(), (String)"1");
        ((FixtureBean)Mockito.verify((Object)this.fixtureBean)).setAge(5);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fixtureBean});
    }
}

