/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.processors;

import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.Trees;
import fluent.api.processors.EndScanner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class EndProcessor
extends AbstractProcessor {
    private static final String resources = "fluent-api-check-methods.txt";

    @Override
    public synchronized void init(final ProcessingEnvironment env) {
        super.init(env);
        this.markChecked(env.getFiler());
        JavacTask.instance(env).addTaskListener(new TaskListener(){
            private EndScanner scanner;
            {
                this.scanner = new EndScanner(EndProcessor.this.loadEndMethodsFromFiles(), Trees.instance(env), env.getTypeUtils());
            }

            @Override
            public void started(TaskEvent taskEvent) {
            }

            @Override
            public void finished(TaskEvent taskEvent) {
                if (taskEvent.getKind() == TaskEvent.Kind.ANALYZE) {
                    try {
                        this.scanner.scan(taskEvent.getCompilationUnit(), null);
                    }
                    catch (RuntimeException runtimeException) {
                        env.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unable to finish @End method check: " + runtimeException, taskEvent.getTypeElement());
                    }
                }
            }
        });
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return false;
    }

    private void markChecked(Filer filer) {
        try (Writer writer = filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "required-method.checked", new Element[0]).openWriter();){
            writer.write("Checked\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Map<String, Set<String>> loadEndMethodsFromFiles() {
        ConcurrentHashMap<String, Set<String>> map = new ConcurrentHashMap<String, Set<String>>();
        try {
            Enumeration<URL> endingMethodResources = ClassLoader.getSystemResources(resources);
            while (endingMethodResources.hasMoreElements()) {
                URL url = endingMethodResources.nextElement();
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                Throwable throwable = null;
                try {
                    reader.lines().forEach(line -> this.addExternalEndingMethod((String)line, (Map<String, Set<String>>)map, url));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }

    private void addExternalEndingMethod(String line, Map<String, Set<String>> map, URL url) {
        int i = line.lastIndexOf(46);
        TypeElement type = this.processingEnv.getElementUtils().getTypeElement(line.substring(0, i));
        if (Objects.isNull(type)) {
            this.warning(line, url, "Class not found");
        } else if (this.methodsOf(type).filter(method -> method.equals(line.substring(i + 1))).peek(method -> map.computeIfAbsent(type.toString(), key -> new HashSet()).add(method)).count() == 0L) {
            this.warning(line, url, "Method not found. Candidates are: " + this.methodsOf(type).collect(Collectors.joining(", ")));
        }
    }

    private void warning(String line, URL url, String reason) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Not recognized ending method " + line + " defined in " + url + ": " + reason + "!");
    }

    private Stream<? extends String> methodsOf(Element type) {
        return type.getEnclosedElements().stream().filter(member -> member.getKind() == ElementKind.METHOD).map(Object::toString);
    }
}

