/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.processors;

import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import fluent.api.End;
import fluent.api.IgnoreMissingEndMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

class EndScanner
extends TreePathScanner<Void, Void> {
    private final Map<String, Set<String>> endMethodsCache;
    private final Trees trees;
    private final Types types;
    private final StartScanner startScanner = new StartScanner();

    EndScanner(Map<String, Set<String>> endMethodsCache, Trees trees, Types types) {
        this.endMethodsCache = endMethodsCache;
        this.trees = trees;
        this.types = types;
    }

    private Set<String> getMethods(Tree tree) {
        return this.getMethods(this.trees.getTypeMirror(this.trees.getPath(this.getCurrentPath().getCompilationUnit(), tree)));
    }

    private Set<String> getMethods(TypeMirror typeMirror) {
        Element element = this.types.asElement(typeMirror);
        if (Objects.isNull(element)) {
            return Collections.emptySet();
        }
        String elementName = element.toString();
        if (!this.endMethodsCache.containsKey(elementName)) {
            Set<String> methods = this.getMethods(element);
            this.endMethodsCache.put(elementName, methods);
        }
        return this.endMethodsCache.get(elementName);
    }

    private String message(Collection<String> m) {
        return "Method chain must end with " + (m.size() > 1 ? "one of the following methods: " : "the method: ") + m;
    }

    @Override
    public Void visitExpressionStatement(ExpressionStatementTree statement, Void aVoid) {
        HashSet<String> methods;
        Boolean hasEnd;
        Element element;
        ExpressionTree expression = statement.getExpression();
        if (expression.getKind() != Tree.Kind.ASSIGNMENT && Objects.nonNull(element = this.element(expression)) && !Boolean.TRUE.equals(hasEnd = expression.accept(this.startScanner, methods = new HashSet<String>(this.getMethods(expression)))) && !methods.isEmpty()) {
            this.trees.printMessage(Diagnostic.Kind.ERROR, this.message(methods), statement, this.getCurrentPath().getCompilationUnit());
        }
        return aVoid;
    }

    private Element element(Tree tree) {
        return this.trees.getElement(this.trees.getPath(this.getCurrentPath().getCompilationUnit(), tree));
    }

    private boolean ignoreCheck(Tree tree) {
        return Objects.nonNull(this.element(tree).getAnnotation(IgnoreMissingEndMethod.class));
    }

    @Override
    public Void visitMethod(MethodTree methodTree, Void aVoid) {
        return this.ignoreCheck(methodTree) ? aVoid : (Void)super.visitMethod(methodTree, aVoid);
    }

    private Set<String> getMethods(Element element) {
        Set methods = element.getEnclosedElements().stream().filter(EndScanner::isAnnotatedEndMethod).map(Object::toString).collect(Collectors.toSet());
        this.types.directSupertypes(element.asType()).forEach(type -> methods.addAll(this.getMethods((TypeMirror)type)));
        return methods.isEmpty() ? Collections.emptySet() : methods;
    }

    private static boolean isAnnotatedEndMethod(Element method) {
        return Objects.nonNull(method.getAnnotation(End.class));
    }

    private static boolean isConstructor(Element method) {
        return method.getKind() == ElementKind.CONSTRUCTOR;
    }

    private boolean isExternalEndMethod(Element method) {
        return this.endMethodsCache.getOrDefault(method.getEnclosingElement().toString(), Collections.emptySet()).contains(method.toString());
    }

    private class StartScanner
    extends TreeScanner<Boolean, Set<String>> {
        private StartScanner() {
        }

        @Override
        public Boolean visitMethodInvocation(MethodInvocationTree tree, Set<String> methods) {
            Element method = EndScanner.this.element(tree);
            if (EndScanner.isConstructor(method) || EndScanner.isAnnotatedEndMethod(method) || EndScanner.this.isExternalEndMethod(method)) {
                return true;
            }
            super.visitMethodInvocation(tree, methods);
            return methods.isEmpty();
        }

        @Override
        public Boolean visitMemberSelect(MemberSelectTree tree, Set<String> methods) {
            tree.getExpression().accept(this, methods);
            methods.addAll(EndScanner.this.getMethods(tree.getExpression()));
            return methods.isEmpty();
        }
    }
}

