/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.processors;

import fluent.api.End;
import fluent.api.Start;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

class AnnotationUtils {
    private final Map<String, Set<String>> endMethodsCache;
    private final Types types;

    AnnotationUtils(Map<String, Set<String>> endMethodsCache, Types types) {
        this.endMethodsCache = endMethodsCache;
        this.types = types;
    }

    boolean isStart(Element element, String[] errorMessage) {
        Start start = element.getAnnotation(Start.class);
        if (Objects.isNull(start)) {
            return false;
        }
        errorMessage[0] = start.value();
        return true;
    }

    boolean isEnd(Element element, String[] errorMessage) {
        End end = element.getAnnotation(End.class);
        if (Objects.isNull(end)) {
            return this.endMethodsCache.getOrDefault(element.getEnclosingElement().toString(), Collections.emptySet()).contains(element.toString());
        }
        if (!end.message().isEmpty()) {
            errorMessage[0] = end.message();
        }
        return true;
    }

    boolean requiresEnd(TypeMirror tree, String[] errorMessage) {
        Set<String> methods = this.getEndMethods(tree, errorMessage);
        if (!methods.isEmpty()) {
            if (errorMessage[0] == null) {
                errorMessage[0] = "Method chain must end with " + (methods.size() > 1 ? "one of the following methods: " : "method: ") + methods;
            }
            return true;
        }
        return false;
    }

    private Set<String> getEndMethods(TypeMirror typeMirror, String[] errorMessage) {
        Element element = this.types.asElement(typeMirror);
        if (Objects.isNull(element)) {
            return Collections.emptySet();
        }
        String elementName = element.toString();
        if (!this.endMethodsCache.containsKey(elementName)) {
            this.endMethodsCache.put(elementName, this.getEndMethods(element, errorMessage));
        }
        return this.endMethodsCache.get(elementName);
    }

    private Set<String> getEndMethods(Element element, String[] errorMessage) {
        Set methods = element.getEnclosedElements().stream().filter(e -> this.isEnd((Element)e, errorMessage)).map(Object::toString).collect(Collectors.toSet());
        this.types.directSupertypes(element.asType()).forEach(type -> methods.addAll(this.getEndMethods((TypeMirror)type, errorMessage)));
        return methods.isEmpty() ? Collections.emptySet() : methods;
    }
}

