/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.processors;

import com.sun.source.util.JavacTask;
import com.sun.source.util.Trees;
import fluent.api.EndMethodCheckFile;
import fluent.api.processors.AnnotationUtils;
import fluent.api.processors.DslScanner;
import fluent.api.processors.UnterminatedSentenceScanner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"fluent.api.EndMethodCheckFile"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class EndProcessor
extends AbstractProcessor {
    private static final String EXTERNAL_END_METHOD_FILE = "fluent-api-check-methods.txt";

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        Trees trees = Trees.instance(env);
        Types types = env.getTypeUtils();
        DslScanner endScanner = new DslScanner(new UnterminatedSentenceScanner(new AnnotationUtils(this.loadEndMethodsFromFiles(), types), trees), trees, types);
        JavacTask.instance(env).addTaskListener(endScanner);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        roundEnv.getElementsAnnotatedWith(EndMethodCheckFile.class).forEach(element -> {
            EndMethodCheckFile checkFile = element.getAnnotation(EndMethodCheckFile.class);
            try (Writer writer = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", checkFile.uniqueFileName(), new Element[0]).openWriter();){
                writer.write(checkFile.content());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return false;
    }

    private Map<String, Set<String>> loadEndMethodsFromFiles() {
        ConcurrentHashMap<String, Set<String>> map = new ConcurrentHashMap<String, Set<String>>();
        try {
            Enumeration<URL> endingMethodResources = ClassLoader.getSystemResources(EXTERNAL_END_METHOD_FILE);
            while (endingMethodResources.hasMoreElements()) {
                URL url = endingMethodResources.nextElement();
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                Throwable throwable = null;
                try {
                    reader.lines().forEach(line -> this.addExternalEndingMethod((String)line, (Map<String, Set<String>>)map, url));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }

    private void addExternalEndingMethod(String line, Map<String, Set<String>> map, URL url) {
        int i = line.lastIndexOf(46);
        TypeElement type = this.processingEnv.getElementUtils().getTypeElement(line.substring(0, i));
        if (Objects.isNull(type)) {
            this.warning(line, url, "Class not found");
        } else if (this.methodsOf(type).filter(method -> method.equals(line.substring(i + 1))).peek(method -> map.computeIfAbsent(type.toString(), key -> new HashSet()).add(method)).count() == 0L) {
            this.warning(line, url, "Method not found. Candidates are: " + this.methodsOf(type).collect(Collectors.joining(", ")));
        }
    }

    private void warning(String line, URL url, String reason) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Not recognized ending method " + line + " defined in " + url + ": " + reason + "!");
    }

    private Stream<? extends String> methodsOf(Element type) {
        return type.getEnclosedElements().stream().filter(member -> member.getKind() == ElementKind.METHOD).map(Object::toString);
    }

    public static void assertThatEndMethodCheckFileExists(String uniqueFileName) throws IOException {
        Enumeration<URL> resources = ClassLoader.getSystemResources(uniqueFileName);
        if (!resources.hasMoreElements()) {
            throw new AssertionError((Object)("End method check uniqueFileName named: " + uniqueFileName + " doesn't exist.\nEither you didn't use anywhere the annotation @EndMethodCheckFile(\"" + uniqueFileName + "\")\nor the annotation processor wasn't invoked by the compiler and you have to check it's configuration.\nFor more about annotation processor configuration and possible issues see:\nhttps://github.com/c0stra/fluent-api-end-check"));
        }
        URL url = resources.nextElement();
        if (resources.hasMoreElements()) {
            throw new IllegalArgumentException("Too many files with the same name: " + uniqueFileName + " found on class-path.\nChosen end method check file name is not unique.\nFiles found:\n" + url + "\n" + resources.nextElement());
        }
    }
}

