/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.processors;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import fluent.api.processors.AnnotationUtils;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

class UnterminatedSentenceScanner
extends TreePathScanner<Boolean, String[]> {
    private final AnnotationUtils utils;
    private final Trees trees;

    UnterminatedSentenceScanner(AnnotationUtils utils, Trees trees) {
        this.utils = utils;
        this.trees = trees;
    }

    private Boolean visitExpression(Tree tree, String[] errorMessage) {
        Element element = this.element(tree);
        if (this.utils.isEnd(element, errorMessage)) {
            return false;
        }
        if (this.utils.requiresEnd(this.type(tree), errorMessage)) {
            return true;
        }
        return tree.accept(this, errorMessage);
    }

    @Override
    public Boolean visitExpressionStatement(ExpressionStatementTree tree, String[] errorMessage) {
        return this.visitExpression(tree.getExpression(), errorMessage);
    }

    @Override
    public Boolean visitLambdaExpression(LambdaExpressionTree tree, String[] errorMessage) {
        return this.visitExpression(tree.getBody(), errorMessage);
    }

    @Override
    public Boolean visitMemberReference(MemberReferenceTree tree, String[] errorMessage) {
        Element member = this.element(tree);
        if (this.utils.isEnd(member, errorMessage)) {
            return false;
        }
        if (this.utils.isStart(member, errorMessage) || this.utils.requiresEnd(this.typeOf(member), errorMessage)) {
            return true;
        }
        return (Boolean)super.visitMemberReference(tree, errorMessage);
    }

    @Override
    public Boolean visitMethodInvocation(MethodInvocationTree tree, String[] errorMessage) {
        return tree.getMethodSelect().accept(this, errorMessage);
    }

    @Override
    public Boolean visitNewClass(NewClassTree tree, String[] errorMessage) {
        return this.utils.requiresEnd(this.type(tree), errorMessage);
    }

    @Override
    public Boolean visitArrayAccess(ArrayAccessTree tree, String[] strings) {
        return tree.getExpression().accept(this, strings);
    }

    @Override
    public Boolean visitIdentifier(IdentifierTree identifierTree, String[] errorMessage) {
        return this.utils.isStart(this.element(identifierTree), errorMessage);
    }

    @Override
    public Boolean visitMemberSelect(MemberSelectTree tree, String[] errorMessage) {
        Element member = this.element(tree);
        if (this.utils.isStart(member, errorMessage)) {
            return true;
        }
        if (this.utils.isEnd(member, errorMessage)) {
            return false;
        }
        if (member.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        if (!"this".equals(tree.getExpression().toString()) && this.utils.requiresEnd(this.type(tree.getExpression()), errorMessage)) {
            return true;
        }
        return tree.getExpression().accept(this, errorMessage);
    }

    @Override
    public Boolean visitConditionalExpression(ConditionalExpressionTree tree, String[] strings) {
        return Boolean.TRUE.equals(tree.getTrueExpression().accept(this, strings)) || Boolean.TRUE.equals(tree.getFalseExpression().accept(this, strings));
    }

    @Override
    public Boolean visitAssignment(AssignmentTree assignmentTree, String[] strings) {
        return null;
    }

    @Override
    public Boolean visitNewArray(NewArrayTree tree, String[] strings) {
        return null;
    }

    private Element element(Tree tree) {
        return this.trees.getElement(this.trees.getPath(this.getCurrentPath().getCompilationUnit(), tree));
    }

    private TypeMirror type(Tree tree) {
        return this.trees.getTypeMirror(this.trees.getPath(this.getCurrentPath().getCompilationUnit(), tree));
    }

    private TypeMirror typeOf(Element element) {
        return element.accept(new ElementVisitor<TypeMirror, Void>(){

            @Override
            public TypeMirror visit(Element e, Void aVoid) {
                return e.accept(this, aVoid);
            }

            @Override
            public TypeMirror visit(Element e) {
                return e.accept(this, null);
            }

            @Override
            public TypeMirror visitPackage(PackageElement e, Void aVoid) {
                return e.asType();
            }

            @Override
            public TypeMirror visitType(TypeElement e, Void aVoid) {
                return e.asType();
            }

            @Override
            public TypeMirror visitVariable(VariableElement e, Void aVoid) {
                return e.asType();
            }

            @Override
            public TypeMirror visitExecutable(ExecutableElement e, Void aVoid) {
                return e.getKind() == ElementKind.CONSTRUCTOR ? this.visit(e.getEnclosingElement()) : e.getReturnType();
            }

            @Override
            public TypeMirror visitTypeParameter(TypeParameterElement e, Void aVoid) {
                return e.asType();
            }

            @Override
            public TypeMirror visitUnknown(Element e, Void aVoid) {
                return e.asType();
            }
        }, null);
    }
}

