/*
 * BSD 2-Clause License
 *
 * Copyright (c) 2018, Ondrej Fischer
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 *  Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

package fluent.api.processors;

import javax.lang.model.element.*;
import java.util.function.BiPredicate;

class ExecutableElementTest<P> implements ElementVisitor<Boolean, P> {

    private final BiPredicate<ExecutableElement, P> consumer;

    ExecutableElementTest(BiPredicate<ExecutableElement, P> consumer) {
        this.consumer = consumer;
    }

    @Override
    public Boolean visit(Element e, P o) {
        return false;
    }

    @Override
    public Boolean visit(Element e) {
        return false;
    }

    @Override
    public Boolean visitPackage(PackageElement e, P o) {
        return false;
    }

    @Override
    public Boolean visitType(TypeElement e, P o) {
        return false;
    }

    @Override
    public Boolean visitVariable(VariableElement e, P o) {
        return false;
    }

    @Override
    public Boolean visitExecutable(ExecutableElement e, P methods) {
        return consumer.test(e, methods);
    }

    @Override
    public Boolean visitTypeParameter(TypeParameterElement e, P o) {
        return false;
    }

    @Override
    public Boolean visitUnknown(Element e, P o) {
        return false;
    }

}
