/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.processors;

import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import fluent.api.IgnoreMissingEndMethod;
import fluent.api.processors.ExecutableElementTest;
import fluent.api.processors.UnterminatedSentenceScanner;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

class DslScanner
extends TreePathScanner<Void, Void>
implements TaskListener {
    private final UnterminatedSentenceScanner unterminatedSentenceScanner;
    private final Trees trees;
    private final Types types;

    DslScanner(UnterminatedSentenceScanner unterminatedSentenceScanner, Trees trees, Types types) {
        this.unterminatedSentenceScanner = unterminatedSentenceScanner;
        this.trees = trees;
        this.types = types;
    }

    @Override
    public void started(TaskEvent taskEvent) {
    }

    @Override
    public void finished(TaskEvent taskEvent) {
        if (taskEvent.getKind() == TaskEvent.Kind.ANALYZE) {
            try {
                this.scan(taskEvent.getCompilationUnit(), null);
            }
            catch (RuntimeException runtimeException) {
                StringWriter writer = new StringWriter();
                runtimeException.printStackTrace(new PrintWriter(writer));
                this.trees.printMessage(Diagnostic.Kind.ERROR, "@End method check failed. Please raise report at: https://github.com/c0stra/fluent-api-end-check/issues with following details: " + writer, taskEvent.getCompilationUnit(), taskEvent.getCompilationUnit());
            }
        }
    }

    @Override
    public Void visitMethod(MethodTree methodTree, Void aVoid) {
        Element element = this.trees.getElement(this.trees.getPath(this.getCurrentPath().getCompilationUnit(), methodTree));
        return Objects.nonNull(element.getAnnotation(IgnoreMissingEndMethod.class)) ? null : (Void)super.visitMethod(methodTree, aVoid);
    }

    private void visitExpression(Tree tree, Tree statement) {
        if (tree.getKind() != Tree.Kind.ASSIGNMENT) {
            this.unterminatedSentenceScanner.scan(this.getCurrentPath(), statement);
        }
    }

    @Override
    public Void visitExpressionStatement(ExpressionStatementTree statement, Void aVoid) {
        this.visitExpression(statement.getExpression(), statement);
        return (Void)super.visitExpressionStatement(statement, aVoid);
    }

    @Override
    public Void visitLambdaExpression(LambdaExpressionTree tree, Void aVoid) {
        if (tree.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION && this.isVoidLambda(tree)) {
            this.visitExpression(tree.getBody(), tree);
        }
        return (Void)super.visitLambdaExpression(tree, null);
    }

    @Override
    public Void visitMemberReference(MemberReferenceTree tree, Void aVoid) {
        ExpressionTree expression = tree.getQualifierExpression();
        if (this.isVoidLambda(tree)) {
            this.unterminatedSentenceScanner.scan(this.getCurrentPath(), tree);
        }
        return expression.accept(this, null);
    }

    private boolean isVoidLambda(Tree tree) {
        ExecutableElementTest<Void> test = new ExecutableElementTest<Void>((e, o) -> !e.isDefault() && !e.getModifiers().contains((Object)Modifier.STATIC) && "void".equals(e.getReturnType().toString()));
        return this.types.asElement(this.trees.getTypeMirror(this.trees.getPath(this.getCurrentPath().getCompilationUnit(), tree))).getEnclosedElements().stream().anyMatch(m -> (Boolean)m.accept(test, null));
    }
}

