/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.processors;

import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import fluent.api.End;
import fluent.api.Start;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

class UnterminatedSentenceScanner
extends TreePathScanner<Void, Tree> {
    private final Map<String, Set<String>> endMethodsCache;
    private final Trees trees;
    private final Types types;
    private String lastError = "";

    UnterminatedSentenceScanner(Map<String, Set<String>> endMethodsCache, Trees trees, Types types) {
        this.endMethodsCache = endMethodsCache;
        this.trees = trees;
        this.types = types;
    }

    private boolean isStartExpression(Element element, Tree statement) {
        Set<String> methods;
        if (statement.toString().startsWith("super(") || statement.toString().startsWith("this(")) {
            return false;
        }
        Set<String> set = methods = element.getKind() == ElementKind.CONSTRUCTOR ? this.getMethods(element.getEnclosingElement().asType()) : this.getMethods(((ExecutableElement)element).getReturnType());
        if (!methods.isEmpty() || this.isAnnotatedStartMethod(element)) {
            this.trees.printMessage(Diagnostic.Kind.ERROR, this.message(methods), statement, this.getCurrentPath().getCompilationUnit());
            return true;
        }
        return false;
    }

    private boolean endOrStartFound(ExpressionTree tree, Tree statement) {
        Element element = this.element(tree);
        return this.isEndMethod(element) || this.isStartExpression(element, statement) || UnterminatedSentenceScanner.isConstructorOrStaticMethod(element);
    }

    private Void visitExpression(final ExpressionTree tree, Tree statement) {
        if (tree.accept(new SimpleTreeVisitor<Boolean, Void>(Boolean.valueOf(false)){

            @Override
            public Boolean visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void aVoid) {
                return UnterminatedSentenceScanner.this.isEndMethod(UnterminatedSentenceScanner.this.element(tree));
            }
        }, null).booleanValue()) {
            return null;
        }
        HashSet<String> endMethods = new HashSet<String>(this.getMethods(tree));
        tree.accept(this, statement);
        if (!endMethods.isEmpty()) {
            this.trees.printMessage(Diagnostic.Kind.ERROR, this.message(endMethods), statement, this.getCurrentPath().getCompilationUnit());
        }
        return null;
    }

    @Override
    public Void visitExpressionStatement(ExpressionStatementTree expressionStatementTree, Tree tree) {
        return this.visitExpression(expressionStatementTree.getExpression(), tree);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree tree, Tree statement) {
        return this.endOrStartFound(tree, statement) ? null : tree.getMethodSelect().accept(this, statement);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree tree, Tree statement) {
        return this.isStartExpression(this.element(tree), statement) ? null : this.visitExpression(tree.getExpression(), statement);
    }

    @Override
    public Void visitMemberReference(MemberReferenceTree tree, Tree statement) {
        return this.endOrStartFound(tree, statement) ? null : (Void)super.visitMemberReference(tree, statement);
    }

    @Override
    public Void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree, Tree tree) {
        return this.visitExpression((ExpressionTree)lambdaExpressionTree.getBody(), tree);
    }

    private Set<String> getMethods(Tree tree) {
        return "this".equals(tree.toString()) ? Collections.emptySet() : this.getMethods(this.trees.getTypeMirror(this.trees.getPath(this.getCurrentPath().getCompilationUnit(), tree)));
    }

    private Set<String> getMethods(TypeMirror typeMirror) {
        Element element = this.types.asElement(typeMirror);
        if (Objects.isNull(element)) {
            return Collections.emptySet();
        }
        String elementName = element.toString();
        if (!this.endMethodsCache.containsKey(elementName)) {
            this.endMethodsCache.put(elementName, this.getMethods(element));
        }
        return this.endMethodsCache.get(elementName);
    }

    private String message(Collection<String> m) {
        return this.lastError.isEmpty() ? "Method chain must end with " + (m.size() > 1 ? "one of the following methods: " : "method: ") + m : this.lastError;
    }

    private Element element(Tree tree) {
        return this.trees.getElement(this.trees.getPath(this.getCurrentPath().getCompilationUnit(), tree));
    }

    private Set<String> getMethods(Element element) {
        Set methods = element.getEnclosedElements().stream().filter(this::isAnnotatedEndMethod).map(Object::toString).collect(Collectors.toSet());
        this.types.directSupertypes(element.asType()).forEach(type -> methods.addAll(this.getMethods((TypeMirror)type)));
        return methods.isEmpty() ? Collections.emptySet() : methods;
    }

    private boolean isAnnotatedEndMethod(Element method) {
        End end = method.getAnnotation(End.class);
        if (Objects.isNull(end)) {
            return false;
        }
        if (!end.message().isEmpty()) {
            this.lastError = end.message();
        }
        return true;
    }

    private boolean isAnnotatedStartMethod(Element method) {
        Start start = method.getAnnotation(Start.class);
        if (Objects.isNull(start)) {
            return false;
        }
        this.lastError = start.value();
        return true;
    }

    private static boolean isConstructorOrStaticMethod(Element method) {
        return method.getKind() == ElementKind.CONSTRUCTOR || method.getModifiers().contains((Object)Modifier.STATIC);
    }

    private boolean isEndMethod(Element method) {
        return this.isAnnotatedEndMethod(method) || this.endMethodsCache.getOrDefault(method.getEnclosingElement().toString(), Collections.emptySet()).contains(method.toString());
    }
}

