/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.processors;

import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import fluent.api.End;
import fluent.api.IgnoreMissingEndMethod;
import fluent.api.processors.ExecutableElementTest;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

class EndScanner
extends TreePathScanner<Void, Set<String>>
implements TaskListener {
    private final Map<String, Set<String>> endMethodsCache;
    private final Trees trees;
    private final Types types;
    private String lastError = "";

    EndScanner(Map<String, Set<String>> endMethodsCache, Trees trees, Types types) {
        this.endMethodsCache = endMethodsCache;
        this.trees = trees;
        this.types = types;
    }

    @Override
    public void started(TaskEvent taskEvent) {
    }

    @Override
    public void finished(TaskEvent taskEvent) {
        if (taskEvent.getKind() == TaskEvent.Kind.ANALYZE) {
            try {
                this.scan(taskEvent.getCompilationUnit(), null);
            }
            catch (RuntimeException runtimeException) {
                this.trees.printMessage(Diagnostic.Kind.WARNING, "Unable to finish @End method check: " + runtimeException, taskEvent.getCompilationUnit(), this.getCurrentPath().getCompilationUnit());
            }
        }
    }

    @Override
    public Void visitMethod(MethodTree methodTree, Set<String> endMethods) {
        return this.ignoreCheck(methodTree) ? null : (Void)super.visitMethod(methodTree, endMethods);
    }

    @Override
    public Void visitExpressionStatement(ExpressionStatementTree statement, Set<String> endMethods) {
        return this.visitExpression(statement.getExpression(), statement);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree tree, Set<String> endMethods) {
        tree.getArguments().forEach(argument -> argument.accept(this, null));
        if (endMethods == null) {
            return tree.getMethodSelect().accept(this, null);
        }
        Element method = this.element(tree);
        if (this.isAnnotatedEndMethod(method) || this.isExternalEndMethod(method)) {
            endMethods.clear();
            return tree.getMethodSelect().accept(this, null);
        }
        endMethods.addAll(this.getMethods(tree));
        return tree.getMethodSelect().accept(this, EndScanner.isConstructor(method) || EndScanner.isStaticMethod(method) ? null : endMethods);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree tree, Set<String> endMethods) {
        if (endMethods == null) {
            return (Void)super.visitMemberSelect(tree, null);
        }
        tree.getExpression().accept(this, endMethods);
        endMethods.addAll(this.getMethods(tree.getExpression()));
        return null;
    }

    @Override
    public Void visitLambdaExpression(LambdaExpressionTree tree, Set<String> endMethods) {
        if (tree.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION && this.isVoidLambda(tree)) {
            return this.visitExpression((ExpressionTree)tree.getBody(), tree);
        }
        return (Void)super.visitLambdaExpression(tree, null);
    }

    @Override
    public Void visitMemberReference(MemberReferenceTree tree, Set<String> endMethods) {
        ExpressionTree expression = tree.getQualifierExpression();
        if (this.isVoidLambda(tree)) {
            HashSet<String> methods = new HashSet<String>(this.getMethods(expression));
            expression.accept(this, methods);
            if (((Boolean)this.element(tree).accept(new ExecutableElementTest<Set>(this::isMethodReferenceEndMethodMissing), methods)).booleanValue()) {
                this.trees.printMessage(Diagnostic.Kind.ERROR, this.message(methods), tree, this.getCurrentPath().getCompilationUnit());
            }
            return null;
        }
        return expression.accept(this, null);
    }

    private Void visitExpression(ExpressionTree tree, Tree statement) {
        if (tree.getKind() == Tree.Kind.ASSIGNMENT) {
            return tree.accept(this, null);
        }
        HashSet<String> endMethods = new HashSet<String>(this.getMethods(tree));
        tree.accept(this, endMethods);
        if (!endMethods.isEmpty()) {
            this.trees.printMessage(Diagnostic.Kind.ERROR, this.message(endMethods), statement, this.getCurrentPath().getCompilationUnit());
        }
        return null;
    }

    private Set<String> getMethods(Tree tree) {
        return "this".equals(tree.toString()) ? Collections.emptySet() : this.getMethods(this.trees.getTypeMirror(this.trees.getPath(this.getCurrentPath().getCompilationUnit(), tree)));
    }

    private Set<String> getMethods(TypeMirror typeMirror) {
        Element element = this.types.asElement(typeMirror);
        return Objects.isNull(element) ? Collections.emptySet() : this.endMethodsCache.computeIfAbsent(element.toString(), elementName -> this.getMethods(element));
    }

    private String message(Collection<String> m) {
        return this.lastError.isEmpty() ? "Method chain must end with " + (m.size() > 1 ? "one of the following methods: " : "method: ") + m : this.lastError;
    }

    private boolean isVoidLambda(Tree tree) {
        ExecutableElementTest<Void> test = new ExecutableElementTest<Void>((e, o) -> !e.isDefault() && !e.getModifiers().contains((Object)Modifier.STATIC) && "void".equals(e.getReturnType().toString()));
        return this.types.asElement(this.trees.getTypeMirror(this.trees.getPath(this.getCurrentPath().getCompilationUnit(), tree))).getEnclosedElements().stream().anyMatch(m -> (Boolean)m.accept(test, null));
    }

    private Element element(Tree tree) {
        return this.trees.getElement(this.trees.getPath(this.getCurrentPath().getCompilationUnit(), tree));
    }

    private boolean ignoreCheck(Tree tree) {
        return Objects.nonNull(this.element(tree).getAnnotation(IgnoreMissingEndMethod.class));
    }

    private Set<String> getMethods(Element element) {
        Set methods = element.getEnclosedElements().stream().filter(this::isAnnotatedEndMethod).map(Object::toString).collect(Collectors.toSet());
        this.types.directSupertypes(element.asType()).forEach(type -> methods.addAll(this.getMethods((TypeMirror)type)));
        return methods.isEmpty() ? Collections.emptySet() : methods;
    }

    private boolean isAnnotatedEndMethod(Element method) {
        End end = method.getAnnotation(End.class);
        if (Objects.isNull(end)) {
            return false;
        }
        if (!end.message().isEmpty()) {
            this.lastError = end.message();
        }
        return true;
    }

    private static boolean isConstructor(Element method) {
        return method.getKind() == ElementKind.CONSTRUCTOR;
    }

    private static boolean isStaticMethod(Element method) {
        return method.getModifiers().contains((Object)Modifier.STATIC);
    }

    private boolean isExternalEndMethod(Element method) {
        return this.endMethodsCache.getOrDefault(method.getEnclosingElement().toString(), Collections.emptySet()).contains(method.toString());
    }

    private boolean isMethodReferenceEndMethodMissing(ExecutableElement e, Set<String> methods) {
        if (this.isAnnotatedEndMethod(e) || this.isExternalEndMethod(e)) {
            return false;
        }
        Element returnType = e.getKind() == ElementKind.CONSTRUCTOR ? e.getEnclosingElement() : this.types.asElement(e.getReturnType());
        methods.addAll(this.getMethods(returnType));
        return !methods.isEmpty();
    }
}

