/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.processors;

import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import fluent.api.End;
import fluent.api.IgnoreMissingEndMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

class EndScanner
extends TreePathScanner<Void, Void> {
    private final Map<String, Set<String>> endMethodsCache;
    private final Trees trees;
    private final Types types;
    private final StartScanner startScanner = new StartScanner();
    private String lastErrorMessage = "";

    EndScanner(Map<String, Set<String>> endMethodsCache, Trees trees, Types types) {
        this.endMethodsCache = endMethodsCache;
        this.trees = trees;
        this.types = types;
    }

    private Set<String> getMethods(Tree tree) {
        if ("this".equals(tree.toString())) {
            return Collections.emptySet();
        }
        return this.getMethods(this.trees.getTypeMirror(this.trees.getPath(this.getCurrentPath().getCompilationUnit(), tree)));
    }

    private Set<String> getMethods(TypeMirror typeMirror) {
        Element element = this.types.asElement(typeMirror);
        if (Objects.isNull(element)) {
            return Collections.emptySet();
        }
        String elementName = element.toString();
        if (!this.endMethodsCache.containsKey(elementName)) {
            Set<String> methods = this.getMethods(element);
            this.endMethodsCache.put(elementName, methods);
        }
        return this.endMethodsCache.get(elementName);
    }

    private String message(Collection<String> m) {
        return this.lastErrorMessage.length() > 0 ? this.lastErrorMessage : "Method chain must end with " + (m.size() > 1 ? "one of the following methods: " : "the method: ") + m;
    }

    private void inspectExpression(ExpressionTree expression, Tree statement) {
        HashSet<String> methods;
        Boolean hasEnd;
        Element element;
        if (expression.getKind() != Tree.Kind.ASSIGNMENT && Objects.nonNull(element = this.element(expression)) && !Boolean.TRUE.equals(hasEnd = expression.accept(this.startScanner, methods = new HashSet<String>(this.getMethods(expression)))) && !methods.isEmpty()) {
            this.trees.printMessage(Diagnostic.Kind.ERROR, this.message(methods), statement, this.getCurrentPath().getCompilationUnit());
        }
    }

    @Override
    public Void visitExpressionStatement(ExpressionStatementTree statement, Void aVoid) {
        this.inspectExpression(statement.getExpression(), statement);
        return statement.getExpression().accept(this, aVoid);
    }

    private boolean isVoidLambda(Tree tree) {
        return this.types.asElement(this.trees.getTypeMirror(this.trees.getPath(this.getCurrentPath().getCompilationUnit(), tree))).getEnclosedElements().stream().anyMatch(m -> m.accept(new VoidLambdaDetector(), null));
    }

    @Override
    public Void visitLambdaExpression(LambdaExpressionTree tree, Void aVoid) {
        if (tree.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION && this.isVoidLambda(tree)) {
            this.inspectExpression((ExpressionTree)tree.getBody(), tree);
        }
        return tree.getBody().accept(this, aVoid);
    }

    @Override
    public Void visitMemberReference(MemberReferenceTree tree, Void aVoid) {
        if (this.isVoidLambda(tree)) {
            ExpressionTree expression = tree.getQualifierExpression();
            HashSet<String> methods = new HashSet<String>(this.getMethods(expression));
            tree.accept(this.startScanner, methods);
            Element element = this.element(tree);
            if (!element.accept(new MissingRequiredMethodReferenceDetector(methods), null).booleanValue()) {
                this.trees.printMessage(Diagnostic.Kind.ERROR, this.message(methods), tree, this.getCurrentPath().getCompilationUnit());
            }
        }
        return tree.getQualifierExpression().accept(this, aVoid);
    }

    private Element element(Tree tree) {
        return this.trees.getElement(this.trees.getPath(this.getCurrentPath().getCompilationUnit(), tree));
    }

    private boolean ignoreCheck(Tree tree) {
        return Objects.nonNull(this.element(tree).getAnnotation(IgnoreMissingEndMethod.class));
    }

    @Override
    public Void visitMethod(MethodTree methodTree, Void aVoid) {
        return this.ignoreCheck(methodTree) ? aVoid : (Void)super.visitMethod(methodTree, aVoid);
    }

    private Set<String> getMethods(Element element) {
        Set methods = element.getEnclosedElements().stream().filter(this::isAnnotatedEndMethod).map(Object::toString).collect(Collectors.toSet());
        this.types.directSupertypes(element.asType()).forEach(type -> methods.addAll(this.getMethods((TypeMirror)type)));
        return methods.isEmpty() ? Collections.emptySet() : methods;
    }

    private boolean isAnnotatedEndMethod(Element method) {
        End end = method.getAnnotation(End.class);
        if (Objects.isNull(end)) {
            return false;
        }
        if (end.message().length() > 0) {
            this.lastErrorMessage = end.message();
        }
        return true;
    }

    private static boolean isConstructor(Element method) {
        return method.getKind() == ElementKind.CONSTRUCTOR;
    }

    private static boolean isStaticMethod(Element method) {
        return method.getModifiers().contains((Object)Modifier.STATIC);
    }

    private boolean isExternalEndMethod(Element method) {
        return this.endMethodsCache.getOrDefault(method.getEnclosingElement().toString(), Collections.emptySet()).contains(method.toString());
    }

    private class MissingRequiredMethodReferenceDetector
    implements ElementVisitor<Boolean, Object> {
        private final Set<String> methods;

        private MissingRequiredMethodReferenceDetector(Set<String> methods) {
            this.methods = methods;
        }

        @Override
        public Boolean visit(Element e, Object o) {
            return true;
        }

        @Override
        public Boolean visit(Element e) {
            return true;
        }

        @Override
        public Boolean visitPackage(PackageElement e, Object o) {
            return true;
        }

        @Override
        public Boolean visitType(TypeElement e, Object o) {
            return true;
        }

        @Override
        public Boolean visitVariable(VariableElement e, Object o) {
            return true;
        }

        @Override
        public Boolean visitExecutable(ExecutableElement e, Object o) {
            if (EndScanner.this.isAnnotatedEndMethod(e)) {
                return true;
            }
            Element returnType = e.getKind() == ElementKind.CONSTRUCTOR ? e.getEnclosingElement() : EndScanner.this.types.asElement(e.getReturnType());
            this.methods.addAll(EndScanner.this.getMethods(returnType));
            return this.methods.isEmpty();
        }

        @Override
        public Boolean visitTypeParameter(TypeParameterElement e, Object o) {
            return true;
        }

        @Override
        public Boolean visitUnknown(Element e, Object o) {
            return true;
        }
    }

    private static class VoidLambdaDetector
    implements ElementVisitor<Boolean, Void> {
        private VoidLambdaDetector() {
        }

        @Override
        public Boolean visit(Element e, Void o) {
            return false;
        }

        @Override
        public Boolean visit(Element e) {
            return false;
        }

        @Override
        public Boolean visitPackage(PackageElement e, Void o) {
            return false;
        }

        @Override
        public Boolean visitType(TypeElement e, Void o) {
            return false;
        }

        @Override
        public Boolean visitVariable(VariableElement e, Void o) {
            return false;
        }

        @Override
        public Boolean visitExecutable(ExecutableElement e, Void o) {
            return !e.isDefault() && !e.getModifiers().contains((Object)Modifier.STATIC) && "void".equals(e.getReturnType().toString());
        }

        @Override
        public Boolean visitTypeParameter(TypeParameterElement e, Void o) {
            return false;
        }

        @Override
        public Boolean visitUnknown(Element e, Void o) {
            return false;
        }
    }

    private class StartScanner
    extends TreeScanner<Boolean, Set<String>> {
        private StartScanner() {
        }

        @Override
        public Boolean visitMethodInvocation(MethodInvocationTree tree, Set<String> methods) {
            Element method = EndScanner.this.element(tree);
            if (EndScanner.this.isAnnotatedEndMethod(method) || EndScanner.this.isExternalEndMethod(method)) {
                return true;
            }
            if (!EndScanner.isConstructor(method) && !EndScanner.isStaticMethod(method)) {
                tree.getMethodSelect().accept(this, methods);
            }
            return methods.isEmpty();
        }

        @Override
        public Boolean visitMemberSelect(MemberSelectTree tree, Set<String> methods) {
            tree.getExpression().accept(this, methods);
            methods.addAll(EndScanner.this.getMethods(tree.getExpression()));
            return methods.isEmpty();
        }
    }
}

