/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.processors;

import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import fluent.api.End;
import fluent.api.IgnoreMissingEndMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

class EndScanner
extends TreePathScanner<Void, Void> {
    private final Map<Element, List<Element>> endMethodsCache = new ConcurrentHashMap<Element, List<Element>>();
    private final Trees trees;
    private final Types types;

    EndScanner(Trees trees, Types types) {
        this.trees = trees;
        this.types = types;
    }

    private List<Element> getMethods(Tree tree) {
        return this.getMethods(this.trees.getTypeMirror(this.trees.getPath(this.getCurrentPath().getCompilationUnit(), tree)));
    }

    private List<Element> getMethods(TypeMirror typeMirror) {
        Element element = this.types.asElement(typeMirror);
        if (Objects.isNull(element)) {
            return Collections.emptyList();
        }
        if (!this.endMethodsCache.containsKey(element)) {
            List<Element> methods = this.getMethods(element);
            this.endMethodsCache.put(element, methods);
        }
        return this.endMethodsCache.get(element);
    }

    private String message(Collection<Element> m) {
        return "Method chain must end with " + (m.size() > 1 ? "one of the following methods: " : "the method: ") + m;
    }

    @Override
    public Void visitExpressionStatement(ExpressionStatementTree statement, Void aVoid) {
        List<Element> mandatoryMethods;
        Element element;
        ExpressionTree expression = statement.getExpression();
        if (expression.getKind() != Tree.Kind.ASSIGNMENT && Objects.nonNull(element = this.element(expression)) && element.getKind() != ElementKind.CONSTRUCTOR && !(mandatoryMethods = this.getMethods(expression)).isEmpty()) {
            this.trees.printMessage(Diagnostic.Kind.ERROR, this.message(mandatoryMethods), statement, this.getCurrentPath().getCompilationUnit());
        }
        return aVoid;
    }

    private Element element(Tree tree) {
        return this.trees.getElement(this.trees.getPath(this.getCurrentPath().getCompilationUnit(), tree));
    }

    private boolean ignoreCheck(Tree tree) {
        return Objects.nonNull(this.element(tree).getAnnotation(IgnoreMissingEndMethod.class));
    }

    @Override
    public Void visitMethod(MethodTree methodTree, Void aVoid) {
        return this.ignoreCheck(methodTree) ? aVoid : (Void)super.visitMethod(methodTree, aVoid);
    }

    private List<Element> getMethods(Element element) {
        List<Element> methods = element.getEnclosedElements().stream().filter(e -> Objects.nonNull(e.getAnnotation(End.class))).collect(Collectors.toList());
        this.types.directSupertypes(element.asType()).forEach(type -> methods.addAll(this.getMethods((TypeMirror)type)));
        return methods;
    }
}

