/*
 * Decompiled with CFR 0.152.
 */
package foundation.fluent.api.dry;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class TypeContext {
    private final Class<?> type;
    private final Map<String, TypeContext> typeParameters;

    public TypeContext(Class<?> type, List<TypeContext> arguments) {
        if (type.getTypeParameters().length != arguments.size()) {
            throw new IllegalArgumentException(Arrays.toString(type.getTypeParameters()) + " required for type " + type + ", but actual provided arguments do not match: " + arguments);
        }
        this.type = type;
        this.typeParameters = Collections.unmodifiableMap(IntStream.range(0, arguments.size()).boxed().collect(Collectors.toMap(i -> type.getTypeParameters()[i].getName(), arguments::get)));
    }

    public TypeContext(Class<?> type) {
        this(type, Collections.emptyList());
    }

    public Class<?> getType() {
        return this.type;
    }

    public Map<String, TypeContext> getTypeParameters() {
        return this.typeParameters;
    }

    public TypeContext resolve(Class<?> declaringClass, Type returnType) {
        return TypeContext.resolve(returnType, TypeContext.contextOf(declaringClass, (TypeContext)this).typeParameters);
    }

    public String toString() {
        return this.type.getName() + (this.typeParameters.isEmpty() ? "" : this.typeParameters);
    }

    private static TypeContext resolve(Type type, Map<String, TypeContext> typeParameters) {
        if (type instanceof Class) {
            return new TypeContext((Class)type);
        }
        if (type instanceof TypeVariable) {
            String name = ((TypeVariable)type).getName();
            if (typeParameters.containsKey(name)) {
                return typeParameters.get(name);
            }
            throw new IllegalStateException("No type argument identified for parameter " + name);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return new TypeContext((Class)parameterizedType.getRawType(), Stream.of(parameterizedType.getActualTypeArguments()).map(t -> TypeContext.resolve(t, typeParameters)).collect(Collectors.toList()));
        }
        throw new IllegalArgumentException("Unsupported type representation: " + type.getClass());
    }

    private static TypeContext contextOf(Class<?> type, TypeContext start) {
        LinkedList<TypeContext> queue = new LinkedList<TypeContext>(Collections.singleton(start));
        TypeContext current = (TypeContext)queue.poll();
        while (current != null) {
            if (current.getType().equals(type)) {
                return current;
            }
            for (Type i : current.getType().getGenericInterfaces()) {
                queue.add(TypeContext.resolve(i, current.typeParameters));
            }
            current = (TypeContext)queue.poll();
        }
        throw new IllegalArgumentException("Class " + type.getName() + " is not inherited by " + start.type.getName());
    }
}

