/*
 * Decompiled with CFR 0.152.
 */
package foundation.fluent.api.dry;

import foundation.fluent.api.dry.DryRunInvocationHandler;
import foundation.fluent.api.dry.TypeContext;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class DryRun {
    private static final Map<Class<?>, Class<?>> primitives = new LinkedHashMap<Class<?>, Class<?>>(){
        {
            this.put(Boolean.class, Boolean.TYPE);
            this.put(Byte.class, Byte.TYPE);
            this.put(Double.class, Double.TYPE);
            this.put(Float.class, Float.TYPE);
            this.put(Character.class, Character.TYPE);
            this.put(Integer.class, Integer.TYPE);
            this.put(Long.class, Long.TYPE);
            this.put(Short.class, Short.TYPE);
        }
    };
    private final Object id;
    private final Map<Class<?>, Object> instances;
    private final DryRunInvocationHandler invocationHandler;

    private DryRun(Object id, Map<Class<?>, Object> instances, DryRunInvocationHandler dryRunInvocationHandler) {
        this.id = id;
        this.invocationHandler = dryRunInvocationHandler;
        this.instances = instances;
    }

    public static Builder create(Object id) {
        return new Builder(id);
    }

    public static Builder createDefault(Object id) {
        return new Builder(id).addDefaultInstances("DRY RUN VALUE", 0, 0L, 0.0, false, Float.valueOf(0.0f), Character.valueOf('?'), (short)0, (byte)0);
    }

    public static Builder create() {
        return new Builder(null);
    }

    private Object proxy(TypeContext context) {
        return Proxy.newProxyInstance(context.getType().getClassLoader(), new Class[]{context.getType()}, (proxy, method, args) -> this.invocationHandler.invoke(this.id, context, proxy, method, args, this));
    }

    public Object invoke(TypeContext context, Method method, Object[] args) {
        switch (method.getName()) {
            case "toString": {
                return this.id.toString();
            }
            case "hashCode": {
                return this.hashCode();
            }
            case "equals": {
                return this.equals(args[0]);
            }
        }
        if (Void.TYPE.equals(method.getReturnType())) {
            return null;
        }
        TypeContext resolvedType = context.resolve(method.getDeclaringClass(), method.getGenericReturnType());
        Class<?> type = resolvedType.getType();
        if (this.instances.containsKey(type)) {
            return this.instances.get(type);
        }
        if (type.isInterface()) {
            return this.proxy(resolvedType);
        }
        throw new IllegalArgumentException("No default value provided for non-interface return type " + type + " of method " + method.getName());
    }

    public static class Builder {
        private final Object id;
        private final Map<Class<?>, Object> instances = new LinkedHashMap();
        private DryRunInvocationHandler handler = (id, context, proxy, method, args, dryRunHandler) -> dryRunHandler.invoke(context, method, args);

        public Builder(Object id2) {
            this.id = id2;
        }

        public Builder handler(DryRunInvocationHandler handler) {
            this.handler = handler;
            return this;
        }

        private Builder add(Class<?> type, Object instance, Object allowed) {
            if (Objects.nonNull(type) && Objects.equals(this.instances.get(type), allowed)) {
                this.instances.put(type, instance);
                this.add(type.getSuperclass(), instance, allowed);
                Stream.of(type.getInterfaces()).forEach(i -> this.add((Class<?>)i, instance, allowed));
                this.add((Class)primitives.get(type), instance, allowed);
            }
            return this;
        }

        public <T> Builder addInstance(Class<T> type, T instance) {
            return this.add(type, instance, this.instances.get(type));
        }

        public <T> Builder addInstance(T instance) {
            return this.add(instance.getClass(), instance, this.instances.get(instance.getClass()));
        }

        public Builder addDefaultInstances(Object ... defaultInstances) {
            Stream.of(defaultInstances).forEach(this::addInstance);
            return this;
        }

        public Builder setDefaultInstances(Object ... defaultInstances) {
            this.instances.clear();
            return this.addDefaultInstances(defaultInstances);
        }

        public <T> T forClass(Class<T> aClass) {
            return aClass.cast(new DryRun(Objects.isNull(this.id) ? aClass.getSimpleName() : this.id, this.instances, this.handler).proxy(new TypeContext(aClass)));
        }
    }
}

