/*
 * Decompiled with CFR 0.152.
 */
package foundation.fluent.api.dry;

import foundation.fluent.api.dry.DryRunInvocationHandler;
import foundation.fluent.api.dry.TypeContext;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class DryRun {
    private static final List<Object> globalDefaultInstances = Arrays.asList("DRY RUN VALUE", 0, false, 0L, 0.0);
    private final Object id;
    private final List<Object> defaultInstances;
    private final DryRunInvocationHandler invocationHandler;

    private DryRun(Object id, List<Object> defaultInstances, DryRunInvocationHandler dryRunInvocationHandler) {
        this.id = id;
        this.defaultInstances = defaultInstances;
        this.invocationHandler = dryRunInvocationHandler;
    }

    public static Builder create(Object id) {
        return new Builder(id);
    }

    private Object proxy(TypeContext context) {
        return Proxy.newProxyInstance(context.getType().getClassLoader(), new Class[]{context.getType()}, (proxy, method, args) -> this.invocationHandler.invoke(this.id, context, proxy, method, args, this));
    }

    public Object invoke(TypeContext context, Method method, Object[] args) {
        switch (method.getName()) {
            case "toString": {
                return this.id.toString();
            }
            case "hashCode": {
                return this.hashCode();
            }
            case "equals": {
                return this.equals(args[0]);
            }
        }
        if (Void.TYPE.equals(method.getReturnType())) {
            return null;
        }
        TypeContext resolvedType = context.resolve(method.getDeclaringClass(), method.getGenericReturnType());
        for (Object defaultInstance : this.defaultInstances) {
            if (!resolvedType.getType().isInstance(defaultInstance)) continue;
            return defaultInstance;
        }
        if (resolvedType.getType().isInterface()) {
            return this.proxy(resolvedType);
        }
        throw new IllegalArgumentException("No default value provided for non-interface return type " + resolvedType.getType() + " of method " + method.getName());
    }

    static /* synthetic */ List access$000() {
        return globalDefaultInstances;
    }

    public static class Builder {
        private final Object id;
        private final List<Object> defaultInstances = new LinkedList<Object>(DryRun.access$000());
        private DryRunInvocationHandler handler;

        public Builder(Object id) {
            this.id = id;
        }

        public Builder handler(DryRunInvocationHandler handler) {
            this.handler = handler;
            return this;
        }

        public Builder addDefaultInstances(Object ... defaultInstances) {
            this.defaultInstances.addAll(Arrays.asList(defaultInstances));
            return this;
        }

        public Builder setDefaultInstances(Object ... defaultInstances) {
            this.defaultInstances.clear();
            return this.addDefaultInstances(defaultInstances);
        }

        public <T> T forClass(Class<T> aClass) {
            return aClass.cast(new DryRun(this.id, this.defaultInstances, this.handler).proxy(new TypeContext(aClass)));
        }
    }
}

