/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.model.impl;

import fluent.api.model.InterfaceModel;
import fluent.api.model.MethodModel;
import fluent.api.model.ModifiersModel;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.api.model.impl.GenericModelImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.type.TypeKind;

public abstract class TypeModelImpl<T extends TypeModel<T>>
extends GenericModelImpl<T>
implements TypeModel<T> {
    private final String packageName;
    private final String simpleName;
    private final String fullName;
    private final TypeKind kind;
    private final T rawType;
    private TypeModel<?> componentType;
    private Map<String, VarModel> fields = new LinkedHashMap<String, VarModel>();
    private List<MethodModel> methods = new ArrayList<MethodModel>();
    private List<InterfaceModel> interfaces = new ArrayList<InterfaceModel>();
    private final List<TypeModel<?>> nestedClasses = new ArrayList();

    public TypeModelImpl(ModifiersModel modifiers, String packageName, String simpleName, String fullName, TypeKind kind) {
        super(modifiers);
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.fullName = fullName;
        this.kind = kind;
        this.rawType = this.t();
    }

    public TypeModelImpl(ModifiersModel modifiers, String packageName, String simpleName, String fullName, TypeKind kind, List<TypeModel<?>> typeParameters, T rawType) {
        super(modifiers);
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.fullName = fullName;
        this.kind = kind;
        this.rawType = rawType;
        this.typeParameters().addAll(typeParameters);
    }

    protected abstract T t();

    @Override
    public String simpleName() {
        return this.simpleName;
    }

    @Override
    public String packageName() {
        return this.packageName;
    }

    @Override
    public String fullName() {
        return this.fullName;
    }

    @Override
    public boolean isArray() {
        return this.kind == TypeKind.ARRAY;
    }

    @Override
    public boolean isTypeVariable() {
        return this.kind == TypeKind.TYPEVAR;
    }

    @Override
    public T rawType() {
        return this.rawType;
    }

    @Override
    public TypeModel<?> componentType() {
        return this.componentType;
    }

    @Override
    public T componentType(TypeModel<?> componentType) {
        this.componentType = componentType;
        return this.t();
    }

    @Override
    public List<MethodModel> methods() {
        return this.methods;
    }

    @Override
    public T methods(List<MethodModel> methods) {
        this.methods = methods;
        return this.t();
    }

    @Override
    public Map<String, VarModel> fields() {
        return this.fields;
    }

    @Override
    public T fields(Map<String, VarModel> fields) {
        this.fields = fields;
        return this.t();
    }

    @Override
    public List<InterfaceModel> interfaces() {
        return this.interfaces;
    }

    @Override
    public List<TypeModel<?>> types() {
        return this.nestedClasses;
    }

    @Override
    public boolean isPrimitive() {
        return this.kind.isPrimitive();
    }

    @Override
    public T typeParameters(List<TypeModel<?>> typeParameters) {
        if (typeParameters.isEmpty()) {
            return this.t();
        }
        String collect = typeParameters.stream().map(TypeModel::fullName).collect(Collectors.joining(", ", "<", ">"));
        return this.construct(collect, typeParameters);
    }

    protected abstract T construct(String var1, List<TypeModel<?>> var2);

    public String toString() {
        return this.fullName();
    }
}

