/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.model.impl;

import fluent.api.model.ClassModel;
import fluent.api.model.InterfaceModel;
import fluent.api.model.MethodModel;
import fluent.api.model.ModelFactory;
import fluent.api.model.ModifiersModel;
import fluent.api.model.StatementModel;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.api.model.impl.ArrayModelImpl;
import fluent.api.model.impl.ClassModelImpl;
import fluent.api.model.impl.ConstructorModelImpl;
import fluent.api.model.impl.DefaultMethodModelImpl;
import fluent.api.model.impl.InterfaceModelImpl;
import fluent.api.model.impl.LazyList;
import fluent.api.model.impl.LazyMap;
import fluent.api.model.impl.MethodModelImpl;
import fluent.api.model.impl.ModifiersModelImpl;
import fluent.api.model.impl.PrimitiveModelImpl;
import fluent.api.model.impl.StaticMethodModelImpl;
import fluent.api.model.impl.VarModelImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class ModelFactoryImpl
implements ModelFactory,
TypeVisitor<TypeModel<?>, Element> {
    private final Elements elements;
    private final Types types;

    public ModelFactoryImpl(Elements elements, Types types) {
        this.elements = elements;
        this.types = types;
    }

    @Override
    public VarModel parameter(TypeModel model, String parameterName) {
        return new VarModelImpl(this.modifiers(new Modifier[0]), model, parameterName);
    }

    @Override
    public InterfaceModel interfaceModel(String packageName, String className) {
        String fullName = packageName.isEmpty() ? className : packageName + "." + className;
        return new InterfaceModelImpl(this.modifiers(Modifier.PUBLIC, Modifier.STATIC), packageName, className, fullName, TypeKind.DECLARED);
    }

    @Override
    public ClassModel classModel(String packageName, String className) {
        String fullName = packageName.isEmpty() ? className : packageName + "." + className;
        return new ClassModelImpl(this.modifiers(Modifier.PUBLIC, Modifier.STATIC), packageName, className, fullName, TypeKind.DECLARED);
    }

    @Override
    public MethodModel method(Collection<Modifier> modifiers, String method, List<VarModel> parameters) {
        return modifiers.contains((Object)Modifier.STATIC) ? new StaticMethodModelImpl(this.modifiers(modifiers), method, parameters) : new MethodModelImpl(this.modifiers(modifiers), method, parameters, false);
    }

    @Override
    public MethodModel method(String method, List<VarModel> parameters) {
        return new MethodModelImpl(this.modifiers(Modifier.PUBLIC), method, parameters, false);
    }

    @Override
    public StatementModel statementModel(final VarModel target, final MethodModel method) {
        return new StatementModel(){

            public String toString() {
                if (Objects.isNull(method)) {
                    return "return " + target.name() + ";";
                }
                String parameters = "(" + method.parameters().stream().map(VarModel::name).collect(Collectors.joining(", ")) + ");";
                if (method.isConstructor()) {
                    return "return new " + method.owner().fullName() + parameters;
                }
                return (method.returnsValue() ? "return " : "") + (method.modifiers().isStatic() ? method.owner().fullName() : target.name()) + "." + method.name() + parameters;
            }
        };
    }

    @Override
    public TypeModel<?> type(Element element) {
        return this.visit(element.asType(), element);
    }

    @Override
    public TypeModel<?> type(TypeMirror typeMirror) {
        return this.visit(typeMirror);
    }

    @Override
    public VarModel parameter(VariableElement model) {
        return new VarModelImpl(this.modifiers(model.getModifiers()), (TypeModel)this.visit(model.asType()), model.getSimpleName().toString());
    }

    @Override
    public MethodModel method(ExecutableElement method) {
        TypeModel<?> owner = this.type(method.getEnclosingElement());
        List<VarModel> parameters = method.getParameters().stream().map(this::parameter).collect(Collectors.toList());
        if (method.getKind() == ElementKind.CONSTRUCTOR) {
            return new ConstructorModelImpl(parameters).returnType(owner).owner(owner);
        }
        String name = method.getSimpleName().toString();
        Object returnType = this.visit(method.getReturnType());
        if (method.getModifiers().contains((Object)Modifier.DEFAULT)) {
            return new DefaultMethodModelImpl(name, parameters).returnType((TypeModel)returnType).owner(owner);
        }
        ModifiersModel modifiers = this.modifiers(method.getModifiers());
        if (method.getModifiers().contains((Object)Modifier.STATIC)) {
            return new StaticMethodModelImpl(modifiers, name, parameters).returnType((TypeModel)returnType).owner(owner);
        }
        return new MethodModelImpl(modifiers, name, parameters, false).returnType((TypeModel)returnType).owner(owner);
    }

    @Override
    public MethodModel constructor(TypeModel<?> type, VarModel ... parameters) {
        return new ConstructorModelImpl(Arrays.asList(parameters)).owner(type).returnType(type);
    }

    @Override
    public VarModel constant(String name) {
        return this.parameter(this.classModel("", name), name);
    }

    @Override
    public MethodModel defaultMethod(String name, List<VarModel> parameters) {
        return new DefaultMethodModelImpl(name, parameters);
    }

    @Override
    public MethodModel staticMethod(String name, List<VarModel> parameters) {
        return new StaticMethodModelImpl(this.modifiers(Modifier.PUBLIC, Modifier.STATIC), name, parameters);
    }

    @Override
    public TypeModel<?> visit(TypeMirror t, Element typeElement) {
        return (TypeModel)t.accept(this, typeElement);
    }

    @Override
    public TypeModel<?> visit(TypeMirror t) {
        return this.visit(t, this.types.asElement(t));
    }

    private TypeModel<?> visitDefault(TypeMirror t) {
        return new PrimitiveModelImpl(t.toString(), t.getKind());
    }

    @Override
    public TypeModel<?> visitPrimitive(PrimitiveType t, Element element) {
        return this.visitDefault(t);
    }

    @Override
    public TypeModel<?> visitNull(NullType t, Element typeElement) {
        return null;
    }

    private ModifiersModel modifiers(Modifier ... modifiers) {
        return this.modifiers(Arrays.asList(modifiers));
    }

    private ModifiersModel modifiers(Collection<Modifier> modifiers) {
        return new ModifiersModelImpl(modifiers);
    }

    @Override
    public TypeModel<?> visitArray(ArrayType t, Element element) {
        Object component = this.visit(t.getComponentType());
        return new ArrayModelImpl(this.modifiers(Modifier.PUBLIC, Modifier.STATIC), component.packageName(), component.simpleName() + "[]", t.toString(), t.getKind()).componentType((TypeModel<?>)component);
    }

    @Override
    public TypeModel<?> visitDeclared(DeclaredType t, Element element) {
        LazyList s = new LazyList(() -> t.getTypeArguments().stream().map(typeMirror -> this.visit((TypeMirror)typeMirror)).collect(Collectors.toList()));
        String packageName = this.elements.getPackageOf(element).getQualifiedName().toString();
        LazyList<MethodModel> m = new LazyList<MethodModel>(() -> ElementFilter.methodsIn(element.getEnclosedElements()).stream().map(this::method).collect(Collectors.toList()));
        LazyMap<String, VarModel> v = new LazyMap<String, VarModel>(() -> ElementFilter.fieldsIn(element.getEnclosedElements()).stream().map(this::parameter).collect(Collectors.toMap(VarModel::name, e -> e)));
        ModifiersModel modifiers = this.modifiers(element.getModifiers());
        String fullName = t.toString();
        String rawFullName = this.raw(fullName);
        String simpleName = fullName.substring(rawFullName.lastIndexOf(46) + 1);
        TypeKind kind = t.getKind();
        return (element.getKind() == ElementKind.INTERFACE ? new InterfaceModelImpl(modifiers, packageName, simpleName, fullName, kind, (List<TypeModel<?>>)s, new InterfaceModelImpl(modifiers, packageName, this.raw(simpleName), rawFullName, kind)) : new ClassModelImpl(modifiers, packageName, simpleName, fullName, kind, (List<TypeModel<?>>)s, new ClassModelImpl(modifiers, packageName, this.raw(simpleName), rawFullName, kind))).methods(m).fields(v);
    }

    private String raw(String generic) {
        return generic.split("<")[0];
    }

    @Override
    public TypeModel<?> visitError(ErrorType t, Element typeElement) {
        return null;
    }

    @Override
    public TypeModel<?> visitTypeVariable(TypeVariable t, Element typeElement) {
        return this.visitDefault(t);
    }

    @Override
    public TypeModel<?> visitWildcard(WildcardType t, Element typeElement) {
        if (t.getSuperBound() != null) {
            return this.visit(t.getSuperBound());
        }
        return this.visit(t.getExtendsBound());
    }

    @Override
    public TypeModel<?> visitExecutable(ExecutableType t, Element typeElement) {
        return null;
    }

    @Override
    public TypeModel<?> visitNoType(NoType t, Element typeElement) {
        return this.visitDefault(t);
    }

    @Override
    public TypeModel visitUnknown(TypeMirror t, Element typeElement) {
        return null;
    }

    @Override
    public TypeModel visitUnion(UnionType t, Element typeElement) {
        return null;
    }

    @Override
    public TypeModel visitIntersection(IntersectionType t, Element typeElement) {
        return null;
    }
}

