/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.model.impl;

import fluent.api.model.MethodModel;
import fluent.api.model.ModifiersModel;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.api.model.impl.GenericModelImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.type.TypeKind;

public class TypeModelImpl
extends GenericModelImpl<TypeModel>
implements TypeModel {
    private final String packageName;
    private final String simpleName;
    private final String fullName;
    private final TypeKind kind;
    private TypeModel rawType = this;
    private TypeModel componentType = this;
    private TypeModel superClass;
    private List<VarModel> fields = new ArrayList<VarModel>();
    private List<MethodModel> methods = new ArrayList<MethodModel>();
    private List<TypeModel> interfaces = new ArrayList<TypeModel>();
    private final List<TypeModel> nestedClasses = new ArrayList<TypeModel>();

    public TypeModelImpl(ModifiersModel modifiers, String packageName, String simpleName, String fullName, TypeKind kind) {
        super(modifiers);
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.fullName = fullName;
        this.kind = kind;
    }

    public TypeModelImpl(ModifiersModel modifiers, String packageName, String simpleName, String fullName, TypeKind kind, List<TypeModel> typeParameters) {
        this(modifiers, packageName, simpleName, fullName, kind);
        this.typeParameters().addAll(typeParameters);
    }

    @Override
    public String simpleName() {
        return this.simpleName;
    }

    @Override
    public String packageName() {
        return this.packageName;
    }

    @Override
    public String fullName() {
        return this.fullName;
    }

    @Override
    public boolean isArray() {
        return this.kind == TypeKind.ARRAY;
    }

    @Override
    public boolean isTypeVariable() {
        return this.kind == TypeKind.TYPEVAR;
    }

    @Override
    public TypeModel rawType() {
        return this.rawType;
    }

    @Override
    public TypeModel rawType(TypeModel rawType) {
        this.rawType = rawType;
        return this;
    }

    @Override
    public TypeModel componentType() {
        return this.componentType;
    }

    @Override
    public TypeModel componentType(TypeModel componentType) {
        this.componentType = componentType;
        return this;
    }

    @Override
    public List<MethodModel> methods() {
        return this.methods;
    }

    @Override
    public TypeModel methods(List<MethodModel> methods) {
        this.methods = methods;
        return this;
    }

    @Override
    public List<VarModel> fields() {
        return this.fields;
    }

    @Override
    public TypeModel fields(List<VarModel> fields) {
        this.fields = fields;
        return this;
    }

    @Override
    public TypeModel superClass() {
        return this.superClass;
    }

    @Override
    public List<TypeModel> interfaces() {
        return this.interfaces;
    }

    @Override
    public TypeModel superClass(TypeModel superClass) {
        this.superClass = superClass;
        return this;
    }

    @Override
    public List<TypeModel> nestedClasses() {
        return this.nestedClasses;
    }

    @Override
    public TypeModel typeParameters(List<TypeModel> typeParameters) {
        if (typeParameters.isEmpty()) {
            return this;
        }
        String collect = typeParameters.stream().map(TypeModel::fullName).collect(Collectors.joining(", ", "<", ">"));
        return new TypeModelImpl(this.modifiers(), this.packageName, this.simpleName + collect, this.fullName + collect, this.kind, typeParameters).rawType(this);
    }
}

