/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.model.impl;

import fluent.api.model.MethodModel;
import fluent.api.model.ModelFactory;
import fluent.api.model.ModifiersModel;
import fluent.api.model.StatementModel;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.api.model.impl.LazyList;
import fluent.api.model.impl.MethodModelImpl;
import fluent.api.model.impl.ModifiersModelImpl;
import fluent.api.model.impl.TypeModelImpl;
import fluent.api.model.impl.VarModelImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class ModelFactoryImpl
implements ModelFactory,
TypeVisitor<TypeModel, Element> {
    private final Elements elements;
    private final Types types;

    public ModelFactoryImpl(Elements elements, Types types) {
        this.elements = elements;
        this.types = types;
    }

    @Override
    public VarModel parameter(TypeModel model, String parameterName) {
        return new VarModelImpl(this.modifiers(new Modifier[0]), model, parameterName);
    }

    @Override
    public TypeModel type(String packageName, String className) {
        String fullName = packageName.isEmpty() ? className : packageName + "." + className;
        return new TypeModelImpl(this.modifiers(Modifier.PUBLIC, Modifier.STATIC), packageName, className, fullName, TypeKind.DECLARED);
    }

    @Override
    public MethodModel method(Collection<Modifier> modifiers, String method, List<VarModel> parameters) {
        return new MethodModelImpl(this.modifiers(modifiers), method, parameters, false);
    }

    @Override
    public MethodModel method(String method, List<VarModel> parameters) {
        return new MethodModelImpl(this.modifiers(Modifier.PUBLIC), method, parameters, false);
    }

    @Override
    public StatementModel statementModel(final VarModel target, final MethodModel method) {
        return new StatementModel(){

            public String toString() {
                String parameters = "(" + method.parameters().stream().map(VarModel::name).collect(Collectors.joining(", ")) + ");";
                if (method.isConstructor()) {
                    return "return new " + method.owner().fullName() + parameters;
                }
                return (method.returnsValue() ? "return " : "") + (method.modifiers().isStatic() ? method.owner().fullName() : target.name()) + "." + method.name() + parameters;
            }
        };
    }

    @Override
    public TypeModel type(Element element) {
        return this.visit(element.asType(), element);
    }

    @Override
    public VarModel parameter(VariableElement model) {
        return new VarModelImpl(this.modifiers(model.getModifiers()), this.visit(model.asType()), model.getSimpleName().toString());
    }

    @Override
    public MethodModel method(ExecutableElement method) {
        TypeModel owner = this.type(method.getEnclosingElement());
        return new MethodModelImpl(this.modifiers(method.getModifiers()), method.getSimpleName().toString(), method.getParameters().stream().map(this::parameter).collect(Collectors.toList()), method.getKind() == ElementKind.CONSTRUCTOR).returnType(method.getKind() == ElementKind.CONSTRUCTOR ? owner : this.visit(method.getReturnType())).owner(owner);
    }

    @Override
    public MethodModel constructor(TypeModel type, VarModel ... parameters) {
        return new MethodModelImpl(this.modifiers(Modifier.PUBLIC, Modifier.STATIC), "<init>", Arrays.asList(parameters), true).owner(type).returnType(type);
    }

    @Override
    public TypeModel visit(TypeMirror t, Element typeElement) {
        return t.accept(this, typeElement);
    }

    @Override
    public TypeModel visit(TypeMirror t) {
        return this.visit(t, this.types.asElement(t));
    }

    private TypeModel visitDefault(TypeMirror t) {
        return new TypeModelImpl(this.modifiers(Modifier.PUBLIC, Modifier.STATIC), "", t.toString(), t.toString(), t.getKind());
    }

    @Override
    public TypeModel visitPrimitive(PrimitiveType t, Element element) {
        return this.visitDefault(t);
    }

    @Override
    public TypeModel visitNull(NullType t, Element typeElement) {
        return null;
    }

    private ModifiersModel modifiers(Modifier ... modifiers) {
        return this.modifiers(Arrays.asList(modifiers));
    }

    private ModifiersModel modifiers(Collection<Modifier> modifiers) {
        return new ModifiersModelImpl(modifiers);
    }

    @Override
    public TypeModel visitArray(ArrayType t, Element element) {
        TypeModel component = this.visit(t.getComponentType());
        return new TypeModelImpl(this.modifiers(Modifier.PUBLIC, Modifier.STATIC), component.packageName(), component.simpleName() + "[]", t.toString(), t.getKind()).componentType(component).methods(new LazyList<MethodModel>(() -> ElementFilter.methodsIn(element.getEnclosedElements()).stream().map(this::method).collect(Collectors.toList()))).fields(new LazyList<VarModel>(() -> ElementFilter.fieldsIn(element.getEnclosedElements()).stream().map(this::parameter).collect(Collectors.toList())));
    }

    @Override
    public TypeModel visitDeclared(DeclaredType t, Element element) {
        LazyList<TypeModel> s = new LazyList<TypeModel>(() -> t.getTypeArguments().stream().map(this::visit).collect(Collectors.toList()));
        String packageName = this.elements.getPackageOf(element).getQualifiedName().toString();
        LazyList<MethodModel> m = new LazyList<MethodModel>(() -> ElementFilter.methodsIn(element.getEnclosedElements()).stream().map(this::method).collect(Collectors.toList()));
        LazyList<VarModel> v = new LazyList<VarModel>(() -> ElementFilter.fieldsIn(element.getEnclosedElements()).stream().map(this::parameter).collect(Collectors.toList()));
        return new TypeModelImpl(this.modifiers(element.getModifiers()), packageName, packageName.isEmpty() ? t.toString() : t.toString().substring(packageName.length() + 1), t.toString(), t.getKind(), s).rawType(new TypeModelImpl(this.modifiers(element.getModifiers()), packageName, element.getSimpleName().toString(), element.toString(), t.getKind()).methods(m).fields(v)).methods(m).fields(v);
    }

    @Override
    public TypeModel visitError(ErrorType t, Element typeElement) {
        return null;
    }

    @Override
    public TypeModel visitTypeVariable(TypeVariable t, Element typeElement) {
        return this.visitDefault(t);
    }

    @Override
    public TypeModel visitWildcard(WildcardType t, Element typeElement) {
        if (t.getSuperBound() != null) {
            return this.visit(t.getSuperBound());
        }
        return this.visit(t.getExtendsBound());
    }

    @Override
    public TypeModel visitExecutable(ExecutableType t, Element typeElement) {
        return null;
    }

    @Override
    public TypeModel visitNoType(NoType t, Element typeElement) {
        return this.visitDefault(t);
    }

    @Override
    public TypeModel visitUnknown(TypeMirror t, Element typeElement) {
        return null;
    }

    @Override
    public TypeModel visitUnion(UnionType t, Element typeElement) {
        return null;
    }

    @Override
    public TypeModel visitIntersection(IntersectionType t, Element typeElement) {
        return null;
    }
}

