/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.model.lazy;

import fluent.api.model.AnnotationModel;
import fluent.api.model.MethodModel;
import fluent.api.model.StatementModel;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.api.model.lazy.Lazy;
import fluent.api.model.lazy.LazyGenericModel;
import java.util.List;
import java.util.function.Supplier;

public class LazyMethodModel
extends LazyGenericModel
implements MethodModel {
    private final TypeModel returnType;
    private final String name;
    private final Lazy<List<VarModel>> parameters;
    private final Lazy<List<StatementModel>> body;

    public LazyMethodModel(Supplier<List<AnnotationModel>> annotationSupplier, boolean isStatic, boolean isPublic, Supplier<List<TypeModel>> typeParameters, TypeModel returnType, String name, Supplier<List<VarModel>> parametersSupplier, Supplier<List<StatementModel>> bodySupplier) {
        super(annotationSupplier, isStatic, isPublic, typeParameters);
        this.returnType = returnType;
        this.name = name;
        this.parameters = Lazy.lazy(parametersSupplier);
        this.body = Lazy.lazy(bodySupplier);
    }

    @Override
    public TypeModel returnType() {
        return this.returnType;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<VarModel> parameters() {
        return this.parameters.get();
    }

    @Override
    public boolean returnsValue() {
        return !"void".equals(this.returnType.fullName());
    }

    @Override
    public List<StatementModel> body() {
        return this.body.get();
    }
}

