/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.model;

import fluent.api.model.MethodModel;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.api.model.lazy.LazyMethodModel;
import fluent.api.model.lazy.LazyTypeModel;
import fluent.api.model.lazy.LazyVarModel;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class ModelFactory
implements TypeVisitor<TypeModel, Element> {
    private final Elements elements;
    private final Types types;

    public ModelFactory(Elements elements, Types types) {
        this.elements = elements;
        this.types = types;
    }

    public MethodModel method(ExecutableElement element) {
        return new LazyMethodModel(Collections::emptyList, element.getModifiers().contains((Object)Modifier.STATIC), element.getModifiers().contains((Object)Modifier.PUBLIC), Collections::emptyList, this.visit(element.getReturnType()), element.getSimpleName().toString(), () -> element.getParameters().stream().map(this::parameter).collect(Collectors.toList()), Collections::emptyList);
    }

    public VarModel parameter(VariableElement element) {
        return new LazyVarModel(Collections::emptyList, element.getModifiers().contains((Object)Modifier.STATIC), element.getModifiers().contains((Object)Modifier.PUBLIC), this.visit(element.asType()), element.getSimpleName().toString());
    }

    public TypeModel type(Element element) {
        return this.visit(element.asType(), element);
    }

    @Override
    public TypeModel visit(TypeMirror t, Element typeElement) {
        return t.accept(this, typeElement);
    }

    @Override
    public TypeModel visit(TypeMirror t) {
        return this.visit(t, this.types.asElement(t));
    }

    private TypeModel visitDefault(TypeMirror t, boolean isTypeVariable) {
        return new LazyTypeModel(Collections::emptyList, true, true, Collections::emptyList, "", t.toString(), t.toString(), isTypeVariable, Collections::emptyList, Collections::emptyList);
    }

    @Override
    public TypeModel visitPrimitive(PrimitiveType t, Element element) {
        return this.visitDefault(t, false);
    }

    @Override
    public TypeModel visitNull(NullType t, Element typeElement) {
        return null;
    }

    @Override
    public TypeModel visitArray(ArrayType t, Element element) {
        TypeModel component = this.visit(t.getComponentType());
        return new LazyTypeModel(Collections::emptyList, true, true, Collections::emptyList, component.packageName(), component.simpleName() + "[]", t.toString(), true, null, () -> component, () -> ElementFilter.methodsIn(element.getEnclosedElements()).stream().map(this::method).collect(Collectors.toList()), () -> ElementFilter.fieldsIn(element.getEnclosedElements()).stream().map(this::parameter).collect(Collectors.toList()));
    }

    @Override
    public TypeModel visitDeclared(DeclaredType t, Element element) {
        Supplier<List<TypeModel>> s = () -> t.getTypeArguments().stream().map(this::visit).collect(Collectors.toList());
        String packageName = this.elements.getPackageOf(element).getQualifiedName().toString();
        boolean isStatic = element.getModifiers().contains((Object)Modifier.STATIC);
        boolean isPublic = element.getModifiers().contains((Object)Modifier.PUBLIC);
        Supplier<List<MethodModel>> m = () -> ElementFilter.methodsIn(element.getEnclosedElements()).stream().map(this::method).collect(Collectors.toList());
        Supplier<List<VarModel>> v = () -> ElementFilter.fieldsIn(element.getEnclosedElements()).stream().map(this::parameter).collect(Collectors.toList());
        Supplier<TypeModel> r = () -> new LazyTypeModel(Collections::emptyList, isStatic, isPublic, s, packageName, element.getSimpleName().toString(), element.toString(), false, null, null, m, v);
        return new LazyTypeModel(Collections::emptyList, isStatic, isPublic, s, packageName, packageName.isEmpty() ? t.toString() : t.toString().substring(packageName.length() + 1), t.toString(), false, r, null, m, v);
    }

    @Override
    public TypeModel visitError(ErrorType t, Element typeElement) {
        return null;
    }

    @Override
    public TypeModel visitTypeVariable(TypeVariable t, Element typeElement) {
        return this.visitDefault(t, true);
    }

    @Override
    public TypeModel visitWildcard(WildcardType t, Element typeElement) {
        if (t.getSuperBound() != null) {
            return this.visit(t.getSuperBound());
        }
        return this.visit(t.getExtendsBound());
    }

    @Override
    public TypeModel visitExecutable(ExecutableType t, Element typeElement) {
        return null;
    }

    @Override
    public TypeModel visitNoType(NoType t, Element typeElement) {
        return this.visitDefault(t, true);
    }

    @Override
    public TypeModel visitUnknown(TypeMirror t, Element typeElement) {
        return null;
    }

    @Override
    public TypeModel visitUnion(UnionType t, Element typeElement) {
        return null;
    }

    @Override
    public TypeModel visitIntersection(IntersectionType t, Element typeElement) {
        return null;
    }
}

