/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.model.lazy;

import fluent.api.model.AnnotationModel;
import fluent.api.model.MethodModel;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.api.model.lazy.Lazy;
import fluent.api.model.lazy.LazyGenericModel;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class LazyTypeModel
extends LazyGenericModel
implements TypeModel {
    private final String simpleName;
    private final String packageName;
    private final String fullName;
    private final boolean isArray;
    private final boolean isTypVariable;
    private final Lazy<TypeModel> rawType;
    private final Lazy<TypeModel> componentType;
    private final Lazy<List<MethodModel>> methods;
    private final Lazy<List<VarModel>> fields;

    public LazyTypeModel(Supplier<List<AnnotationModel>> annotationSupplier, boolean isStatic, boolean isPublic, Supplier<List<TypeModel>> typeParameters, String packageName, String simpleName, String fullName, boolean isArray, Supplier<TypeModel> rawTypeSupplier, Supplier<TypeModel> componentTypeSupplier, Supplier<List<MethodModel>> methodsSupplier, Supplier<List<VarModel>> fieldsSupplier) {
        super(annotationSupplier, isStatic, isPublic, typeParameters);
        this.simpleName = simpleName;
        this.packageName = packageName;
        this.fullName = fullName;
        this.isArray = isArray;
        this.isTypVariable = false;
        this.rawType = Lazy.lazy(this.argOrThis(rawTypeSupplier));
        this.componentType = Lazy.lazy(this.argOrThis(componentTypeSupplier));
        this.methods = Lazy.lazy(methodsSupplier);
        this.fields = Lazy.lazy(fieldsSupplier);
    }

    private Supplier<TypeModel> argOrThis(Supplier<TypeModel> s) {
        return Objects.isNull(s) ? () -> this : s;
    }

    public LazyTypeModel(Supplier<List<AnnotationModel>> annotationSupplier, boolean isStatic, boolean isPublic, Supplier<List<TypeModel>> typeParameters, String packageName, String simpleName, String fullName, boolean isTypVariable, Supplier<List<MethodModel>> methodsSupplier, Supplier<List<VarModel>> fieldsSupplier) {
        super(annotationSupplier, isStatic, isPublic, typeParameters);
        this.simpleName = simpleName;
        this.packageName = packageName;
        this.isArray = false;
        this.isTypVariable = isTypVariable;
        this.fullName = fullName;
        this.rawType = Lazy.lazy(this);
        this.componentType = Lazy.lazy(this);
        this.methods = Lazy.lazy(methodsSupplier);
        this.fields = Lazy.lazy(fieldsSupplier);
    }

    @Override
    public String simpleName() {
        return this.simpleName;
    }

    @Override
    public String packageName() {
        return this.packageName;
    }

    @Override
    public String fullName() {
        return this.fullName;
    }

    @Override
    public boolean isArray() {
        return this.isArray;
    }

    @Override
    public boolean isTypeVariable() {
        return this.isTypVariable;
    }

    @Override
    public TypeModel rawType() {
        return this.rawType.get();
    }

    @Override
    public TypeModel componentType() {
        return this.componentType.get();
    }

    @Override
    public List<MethodModel> methods() {
        return this.methods.get();
    }

    @Override
    public List<VarModel> fields() {
        return this.fields.get();
    }

    public String toString() {
        return this.fullName();
    }
}

