/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.processor;

import fluent.api.model.ModelFactory;
import fluent.api.model.TypeModel;
import fluent.api.model.impl.ModelFactoryImpl;
import fluent.dsl.Dsl;
import fluent.dsl.generator.DslWriter;
import fluent.dsl.processor.DslAnnotationProcessorPlugin;
import fluent.dsl.processor.DslAnnotationProcessorPluginFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"fluent.dsl.Dsl"})
public class DslAnnotationProcessor
extends AbstractProcessor {
    private final List<DslAnnotationProcessorPlugin> plugins = new ArrayList<DslAnnotationProcessorPlugin>();

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        ModelFactoryImpl modelFactory = new ModelFactoryImpl(env.getElementUtils(), env.getTypeUtils());
        try {
            ServiceLoader.load(DslAnnotationProcessorPluginFactory.class, DslAnnotationProcessorPluginFactory.class.getClassLoader()).forEach(arg_0 -> this.lambda$init$0((ModelFactory)modelFactory, arg_0));
        }
        catch (Error | RuntimeException e) {
            env.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unable to load plugin: " + e);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Dsl.class)) {
            this.processElement(element);
        }
        return true;
    }

    private void processElement(Element element) {
        Dsl dsl = element.getAnnotation(Dsl.class);
        try {
            for (DslAnnotationProcessorPlugin plugin : this.plugins) {
                if (!plugin.isFor(element)) continue;
                this.applyPlugin(plugin, element, dsl);
            }
        }
        catch (Throwable throwable) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unable to generate DSL for " + element + ": " + throwable, element);
        }
    }

    private void applyPlugin(DslAnnotationProcessorPlugin plugin, Element element, Dsl dsl) {
        TypeModel<?> model = plugin.process(element, dsl);
        try (PrintWriter writer = new PrintWriter(this.processingEnv.getFiler().createSourceFile(model.rawType().fullName(), new Element[0]).openWriter());){
            DslWriter.dslWriter(writer).writeFile(model);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private /* synthetic */ void lambda$init$0(ModelFactory modelFactory, DslAnnotationProcessorPluginFactory factory) {
        this.plugins.add(factory.createPlugin(modelFactory));
    }
}

