/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.generator;

import fluent.api.model.ClassModel;
import fluent.api.model.ConstructorModel;
import fluent.api.model.DefaultMethodModel;
import fluent.api.model.ElementModel;
import fluent.api.model.GenericModel;
import fluent.api.model.InterfaceModel;
import fluent.api.model.MethodModel;
import fluent.api.model.StatementModel;
import fluent.api.model.StaticMethodModel;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public class DslWriter {
    private static final String tab = "\t";
    private static final Set<String> forbidden = new HashSet<String>(Arrays.asList("toString()", "hashCode()", "getClass()"));
    private final PrintWriter source;
    private final String prefix;

    private DslWriter(PrintWriter source, String prefix) {
        this.source = source;
        this.prefix = prefix;
    }

    public static DslWriter dslWriter(PrintWriter printWriter) {
        return new DslWriter(printWriter, "");
    }

    private DslWriter indent() {
        return new DslWriter(this.source, this.prefix + tab);
    }

    private void println() {
        this.source.println();
    }

    private void println(String line) {
        this.source.println(this.prefix + line);
    }

    private void print(String line) {
        this.source.print(line);
    }

    private void println(String template, String ... args) {
        this.println(String.format(template, args));
    }

    public void writeFile(TypeModel<?> model) {
        this.println("package %s;", model.packageName());
        this.println();
        this.println("import javax.annotation.Generated;");
        this.println("import fluent.api.Start;");
        this.println("import fluent.api.End;");
        this.println();
        this.println("@Generated(\"Generated DSL class\")");
        this.print("public ");
        this.writeType(model);
    }

    public void writeType(TypeModel<?> model) {
        if (model instanceof InterfaceModel) {
            this.writeInterface((InterfaceModel)model);
        }
        if (model instanceof ClassModel) {
            this.writeClass((ClassModel)model);
        }
    }

    public void writeInterface(InterfaceModel model) {
        this.println("interface %s%s {", model.simpleName(), this.interfaces("extends", model.interfaces()));
        DslWriter indent = this.indent();
        model.fields().values().forEach(indent::writeField);
        model.methods().forEach(indent::writeInterfaceMethod);
        model.types().forEach(indent::writeType);
        this.println("}");
    }

    private void writeInterfaceMethod(MethodModel model) {
        if (model instanceof StaticMethodModel) {
            this.writeStaticMethod((StaticMethodModel)model);
        } else if (model instanceof DefaultMethodModel) {
            this.writeDefaultMethod((DefaultMethodModel)model);
        } else {
            this.writeSignature(model);
        }
    }

    private String interfaces(String keyword, List<InterfaceModel> interfaces) {
        return interfaces.isEmpty() ? "" : interfaces.stream().map(TypeModel::fullName).collect(Collectors.joining(", ", " " + keyword + " ", ""));
    }

    public String extend(ClassModel superClass) {
        return Objects.isNull(superClass) ? "" : " extends " + superClass.fullName();
    }

    public void writeField(VarModel model) {
        this.println("%s%s %s%s;", this.modifiers((ElementModel)model), model.type().fullName(), model.name(), Objects.isNull(model.initializer()) ? "" : " = " + model.initializer());
    }

    private String modifiers(ElementModel model) {
        return model.modifiers().keywords().isEmpty() ? "" : model.modifiers().keywords().stream().map(Modifier::toString).collect(Collectors.joining(" ")) + " ";
    }

    public void writeClass(ClassModel model) {
        this.println("public class %s%s%s {", model.simpleName(), this.extend(model.superClass()), this.interfaces("implements", model.interfaces()));
        DslWriter indent = this.indent();
        model.fields().values().forEach(indent::writeField);
        model.methods().forEach(indent::writeClassMethod);
        model.types().forEach(indent::writeType);
        this.println("}");
    }

    private String typeParameters(GenericModel<?> model) {
        return model.typeParameters().isEmpty() ? "" : model.typeParameters().stream().map(TypeModel::simpleName).collect(Collectors.joining(", ", "<", "> "));
    }

    private String annotations(ElementModel model) {
        return model.annotations().stream().map(a -> "@" + a.type().simpleName()).collect(Collectors.joining());
    }

    public void writeSignature(MethodModel model) {
        this.println("%s%s %s(%s);", this.typeParameters((GenericModel<?>)model), model.returnType().fullName(), model.name(), this.parameters(model));
    }

    public void writeClassMethod(MethodModel model) {
        if (model instanceof ConstructorModel) {
            this.writeConstructor((ConstructorModel)model);
        } else if (model instanceof StaticMethodModel) {
            this.writeStaticMethod((StaticMethodModel)model);
        } else {
            this.writeMethod(model);
        }
    }

    public void writeMethod(MethodModel model) {
        this.println("public %s%s %s(%s) {", this.typeParameters((GenericModel<?>)model), model.returnType().fullName(), model.name(), this.parameters(model));
        model.body().forEach(this.indent()::writeStatement);
        this.println("}");
    }

    private void writeStatement(StatementModel statementModel) {
        this.println(statementModel.toString());
    }

    private String parameters(MethodModel model) {
        return model.parameters().stream().map(p -> p.type().fullName() + " " + p.name()).collect(Collectors.joining(", "));
    }

    public void writeConstructor(ConstructorModel model) {
        this.println("%s %s(%s) {", this.modifiers((ElementModel)model), model.returnType().rawType().simpleName(), this.parameters((MethodModel)model));
        model.body().forEach(this.indent()::writeStatement);
        this.println("}");
    }

    public void writeStaticMethod(StaticMethodModel model) {
        this.writeMethod("public static", (MethodModel)model);
    }

    public void writeAnonymousClass(InterfaceModel model) {
        this.println("return new %s() {", model.fullName());
        model.methods().stream().filter(m -> !(m instanceof StaticMethodModel) && !(m instanceof DefaultMethodModel)).forEach(this.indent()::writeAnonymousImplementation);
        this.println("};");
    }

    public void writeAnonymousImplementation(MethodModel model) {
        this.writeMethod("public", model);
    }

    public void writeDefaultMethod(DefaultMethodModel model) {
        if (!forbidden.contains(model.toString())) {
            this.writeMethod("default", (MethodModel)model);
        }
    }

    private void writeMethod(String prefix, MethodModel model) {
        this.println("%s %s%s%s %s(%s) {", prefix, this.annotations((ElementModel)model), this.typeParameters((GenericModel<?>)model), model.returnType().fullName(), model.name(), this.parameters(model));
        if (model.body().isEmpty() && model.returnType() instanceof InterfaceModel) {
            this.indent().writeAnonymousClass((InterfaceModel)model.returnType());
        }
        model.body().forEach(this.indent()::writeStatement);
        this.println("}");
    }
}

