/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.plugin;

import fluent.api.model.ClassModel;
import fluent.api.model.InterfaceModel;
import fluent.api.model.MethodModel;
import fluent.api.model.ModelFactory;
import fluent.api.model.StatementModel;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.dsl.Dsl;
import fluent.dsl.plugin.DslUtils;
import fluent.dsl.plugin.InitialState;
import fluent.dsl.plugin.State;
import fluent.dsl.processor.DslAnnotationProcessorPlugin;
import fluent.dsl.processor.DslAnnotationProcessorPluginFactory;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;

public class BuilderParser
implements DslAnnotationProcessorPlugin {
    private final ModelFactory factory;

    public BuilderParser(ModelFactory factory) {
        this.factory = factory;
    }

    @Override
    public boolean isFor(Element element) {
        return element.getKind() == ElementKind.PARAMETER || element.getKind() == ElementKind.FIELD;
    }

    public InterfaceModel process(Element element, Dsl dsl) {
        TypeModel model = this.factory.parameter((VariableElement)element).type();
        String packageName = DslUtils.override(dsl.packageName(), model.packageName());
        String dslName = DslUtils.override(dsl.className(), model.rawType().simpleName() + "With");
        InterfaceModel dslModel = this.factory.interfaceModel(packageName, dslName);
        Element typeElement = ((DeclaredType)element.asType()).asElement();
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(typeElement.getEnclosedElements());
        boolean hasSetters = ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().anyMatch(DslUtils::isSetter);
        if (hasSetters || constructors.size() > 1) {
            InterfaceModel builderModel = (InterfaceModel)this.factory.interfaceModel("", "Builder").typeParameters(model.typeParameters());
            ClassModel builderImpl = (ClassModel)this.factory.classModel("", "BuilderImpl").typeParameters(builderModel.typeParameters());
            final VarModel object = this.factory.parameter(model, "object");
            builderImpl.interfaces().add(builderModel);
            builderImpl.fields().put(object.name(), object);
            MethodModel constructor = this.factory.constructor((TypeModel)builderImpl, new VarModel[]{object});
            constructor.body().add(new StatementModel(){

                public String toString() {
                    return "this." + object.name() + " = " + object.name() + ";";
                }
            });
            builderImpl.methods().add(constructor);
            this.readConstructors(typeElement, InitialState.start(this.factory, (TypeModel)dslModel, Modifier.PUBLIC, Modifier.STATIC), c -> this.builderConstructor((MethodModel)c, (TypeModel)builderImpl), (TypeModel)builderModel);
            State state = InitialState.start(this.factory, (TypeModel)builderModel, Modifier.PUBLIC);
            VarModel thisModel = this.factory.parameter((TypeModel)builderImpl, "this");
            for (ExecutableElement method : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                if (!DslUtils.isSetter(method)) continue;
                state.keyword(DslUtils.unCapitalize(method.getSimpleName().toString().substring(3))).parameter(this.factory.parameter(method.getParameters().get(0))).body((TypeModel)builderModel, this.factory.statementModel(object, this.factory.method(method)), this.factory.statementModel(thisModel, null));
            }
            dslModel.types().add(builderModel);
            dslModel.types().add(builderImpl);
            MethodModel buildMethod = this.factory.method("build", new VarModel[0]).returnType(model);
            buildMethod.body().add(this.factory.statementModel(object, null));
            builderModel.methods().add(buildMethod);
            builderImpl.methods().addAll(builderModel.methods());
        } else if (constructors.size() == 1 && constructors.get(0).getParameters().size() > 0) {
            this.readConstructors(typeElement, InitialState.start(this.factory, (TypeModel)dslModel, Modifier.PUBLIC, Modifier.STATIC), Function.identity(), model);
        }
        return dslModel;
    }

    private String constructorCall(MethodModel constructor) {
        return "new " + constructor.returnType().fullName() + "(" + constructor.parameters().stream().map(VarModel::name).collect(Collectors.joining(", ")) + ")";
    }

    private void readConstructors(Element element, State state, Function<MethodModel, MethodModel> constructorFactory, TypeModel returnType) {
        for (ExecutableElement constructor : ElementFilter.constructorsIn(element.getEnclosedElements())) {
            this.readMethodParameters(constructor, state, constructorFactory, returnType);
        }
    }

    private void readMethodParameters(ExecutableElement method, State state, Function<MethodModel, MethodModel> constructor, TypeModel returnType) {
        for (VariableElement variableElement : method.getParameters()) {
            state = state.keyword(DslUtils.from(variableElement)).parameter(this.factory.parameter(variableElement));
        }
        state.body(returnType, this.factory.statementModel(null, constructor.apply(this.factory.method(method))));
    }

    private MethodModel builderConstructor(MethodModel constructor, TypeModel typeModel) {
        return this.factory.constructor(typeModel, new VarModel[]{this.factory.parameter(constructor.returnType(), this.constructorCall(constructor))});
    }

    public static final class Factory
    implements DslAnnotationProcessorPluginFactory {
        @Override
        public DslAnnotationProcessorPlugin createPlugin(ModelFactory factory) {
            return new BuilderParser(factory);
        }
    }
}

