/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.plugin;

import fluent.api.model.MethodModel;
import fluent.api.model.ModelFactory;
import fluent.api.model.StatementModel;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.dsl.plugin.DslUtils;
import fluent.dsl.plugin.State;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public class InitialState
implements State {
    private final ModelFactory factory;
    private final TypeModel<?> rootTypeModel;
    private final Modifier[] initialModifiers;

    private InitialState(ModelFactory factory, TypeModel rootTypeModel, Modifier[] initialModifiers) {
        this.factory = factory;
        this.rootTypeModel = rootTypeModel;
        this.initialModifiers = initialModifiers;
    }

    public static State start(ModelFactory factory, TypeModel rootTypeModel, Modifier ... modifiers) {
        return new InitialState(factory, rootTypeModel, modifiers);
    }

    @Override
    public State method(String name) {
        return new MethodState(this.rootTypeModel, name);
    }

    @Override
    public State keyword(String name, Set<String> aliases) {
        return new KeywordState((TypeModel)this.rootTypeModel, name, (Set)aliases, this.initialModifiers);
    }

    @Override
    public State parameter(VarModel variable) {
        return this;
    }

    @Override
    public State constant(VarModel constant) {
        return this;
    }

    @Override
    public void body(TypeModel returnType, StatementModel ... statement) {
    }

    private static String signatureKey(String name, List<VarModel> parameters) {
        return DslUtils.capitalize(name) + parameters.stream().map(p -> DslUtils.simpleName(p.type())).collect(Collectors.joining());
    }

    private class MethodState
    implements State {
        private final TypeModel model;
        private final String methodName;

        private MethodState(TypeModel model, String methodName) {
            this.model = model;
            this.methodName = methodName;
        }

        @Override
        public State method(String name) {
            return this.keyword(this.methodName).method(name);
        }

        @Override
        public State keyword(String name, Set<String> aliases) {
            return new KeywordState(this.model, name, (Set)aliases, new Modifier[]{Modifier.PUBLIC});
        }

        @Override
        public State parameter(VarModel variable) {
            return this.keyword(this.methodName).parameter(variable);
        }

        @Override
        public State constant(VarModel constant) {
            return this.keyword(this.methodName).constant(constant);
        }

        @Override
        public void body(TypeModel returnType, StatementModel ... statement) {
            this.keyword(this.methodName).body(returnType, statement);
        }
    }

    private class KeywordState
    implements State {
        private final TypeModel<?> typeModel;
        private final String methodName;
        private final Set<String> aliases;
        private final Modifier[] modifiers;
        private List<VarModel> parameters = new ArrayList<VarModel>();
        private final Map<String, MethodModel> methodSignatures;

        private KeywordState(TypeModel<?> typeModel, String methodName, Set<String> aliases, Modifier ... modifiers) {
            this.typeModel = typeModel;
            this.methodName = methodName;
            this.aliases = aliases;
            this.methodSignatures = typeModel.methods().stream().collect(Collectors.toMap(m -> InitialState.signatureKey(m.name(), m.parameters()), Function.identity()));
            this.modifiers = modifiers;
        }

        private MethodModel reduce(TypeModel returnType) {
            return this.methodSignatures.computeIfAbsent(InitialState.signatureKey(this.methodName, this.parameters), key -> this.addMethod((String)key, (TypeModel<?>)returnType));
        }

        private MethodModel addMethod(String key, TypeModel<?> returnType) {
            List typeParameters = this.typeModel.typeParameters();
            LinkedHashMap map = new LinkedHashMap();
            typeParameters.forEach(p -> map.put(p.fullName(), p));
            DslUtils.usedTypeParameters(this.parameters).forEach(t -> map.put(t.fullName(), t));
            ArrayList newParameters = new ArrayList(map.values());
            List methodTypeParameters = newParameters.subList(typeParameters.size(), newParameters.size());
            if (Objects.isNull(returnType)) {
                returnType = (TypeModel)InitialState.this.factory.interfaceModel("", key).typeParameters(newParameters);
                this.typeModel.types().add(returnType);
            }
            MethodModel method = (MethodModel)InitialState.this.factory.method(Arrays.asList(this.modifiers), this.methodName, this.parameters).returnType(returnType).typeParameters(methodTypeParameters);
            this.typeModel.methods().add(method);
            for (String alias : this.aliases) {
                MethodModel aliasMethod = (MethodModel)InitialState.this.factory.defaultMethod(alias, this.parameters).returnType(returnType).typeParameters(methodTypeParameters);
                aliasMethod.body().add(InitialState.this.factory.statementModel(InitialState.this.factory.parameter(this.typeModel, "this"), method));
                this.typeModel.methods().add(aliasMethod);
            }
            method.metadata().put("aliases", this.aliases);
            return method;
        }

        @Override
        public State method(String name) {
            return new MethodState(this.reduce(null).returnType(), name);
        }

        @Override
        public State keyword(String name, Set<String> aliases) {
            return new KeywordState(this.reduce(null).returnType(), name, aliases, Modifier.PUBLIC);
        }

        @Override
        public State parameter(VarModel parameter) {
            this.parameters.add(parameter);
            return this;
        }

        @Override
        public State constant(VarModel constant) {
            InitialState.this.rootTypeModel.fields().computeIfAbsent(constant.name(), name -> {
                MethodModel constructor = InitialState.this.factory.constructor(constant.type(), new VarModel[0]);
                constructor.modifiers().keywords().clear();
                constructor.modifiers().keywords().add(Modifier.PRIVATE);
                constant.type().methods().add(constructor);
                InitialState.this.rootTypeModel.types().add(constant.type());
                return constant.initializer("new " + constant.type().fullName() + "()");
            });
            return this.parameter(constant);
        }

        @Override
        public void body(TypeModel returnType, StatementModel ... statement) {
            this.reduce(returnType).body().addAll(Arrays.asList(statement));
        }
    }
}

