/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.plugin;

import fluent.api.model.InterfaceModel;
import fluent.api.model.MethodModel;
import fluent.api.model.ModelFactory;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.dsl.Constant;
import fluent.dsl.Dsl;
import fluent.dsl.plugin.DslUtils;
import fluent.dsl.plugin.InitialState;
import fluent.dsl.plugin.State;
import fluent.dsl.processor.DslAnnotationProcessorPlugin;
import fluent.dsl.processor.DslAnnotationProcessorPluginFactory;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;

public class DslParser
implements DslAnnotationProcessorPlugin {
    private final ModelFactory factory;

    public DslParser(ModelFactory factory) {
        this.factory = factory;
    }

    @Override
    public boolean isFor(Element element) {
        return element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE;
    }

    public InterfaceModel process(Element element, Dsl dsl) {
        TypeModel model = this.factory.type(element);
        String packageName = DslUtils.override(dsl.packageName(), model.packageName());
        String dslName = DslUtils.override(dsl.className(), model.rawType().simpleName() + "Dsl");
        VarModel source = this.factory.parameter(model, dsl.parameterName());
        InterfaceModel dslType = (InterfaceModel)this.factory.interfaceModel(packageName, dslName).typeParameters(model.typeParameters());
        MethodModel factoryMethod = ((MethodModel)this.factory.staticMethod(dsl.factoryMethod(), Collections.singletonList(source)).typeParameters(model.typeParameters())).returnType((TypeModel)dslType);
        this.parseMethods(element, InitialState.start(this.factory, (TypeModel)dslType, Modifier.PUBLIC), source);
        InterfaceModel delegate = (InterfaceModel)this.factory.interfaceModel("", "Delegate").typeParameters(model.typeParameters());
        delegate.interfaces().add(dslType);
        delegate.methods().add(this.factory.method(dsl.delegateMethod(), new VarModel[0]).returnType((TypeModel)dslType));
        dslType.methods().forEach(m -> {
            MethodModel model1 = (MethodModel)this.factory.defaultMethod(m.name(), m.parameters()).returnType(m.returnType()).typeParameters(m.typeParameters());
            model1.body().add(this.factory.statementModel(this.factory.parameter((TypeModel)dslType, dsl.delegateMethod() + "()"), m));
            delegate.methods().add(model1);
        });
        dslType.methods().add(factoryMethod);
        dslType.types().add(delegate);
        return dslType;
    }

    private void parseMethods(Element element, State state, VarModel impl) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            state = this.annotation(state, annotationMirror);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(element.getEnclosedElements())) {
            this.parseParameters(executableElement, state.method(DslUtils.from(executableElement)), impl);
        }
    }

    private void parseParameters(ExecutableElement method, State state, VarModel impl) {
        for (VariableElement variableElement : method.getParameters()) {
            for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                state = this.annotation(state, annotationMirror);
            }
            state = state.parameter(this.factory.parameter(variableElement));
        }
        for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
            state = this.annotation(state, annotationMirror);
        }
        MethodModel methodModel = this.factory.method(method);
        state.body(methodModel.returnType(), this.factory.statementModel(impl, methodModel));
    }

    public State annotation(State state, AnnotationMirror annotation) {
        Element element = annotation.getAnnotationType().asElement();
        if (Objects.nonNull(element.getAnnotation(Constant.class))) {
            return state.constant(this.factory.constant(DslUtils.from(element)));
        }
        if (Objects.nonNull(DslUtils.getDsl(element))) {
            return state.keyword(DslUtils.from(element), this.aliases(element));
        }
        return state;
    }

    private Set<String> aliases(Element element) {
        return element.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.ANNOTATION_TYPE).map(DslUtils::from).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static final class Factory
    implements DslAnnotationProcessorPluginFactory {
        @Override
        public DslAnnotationProcessorPlugin createPlugin(ModelFactory factory) {
            return new DslParser(factory);
        }
    }
}

