/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.processor;

import fluent.api.model.ModelFactory;
import fluent.api.model.TypeModel;
import fluent.api.model.impl.ModelFactoryImpl;
import fluent.dsl.Dsl;
import fluent.dsl.generator.DslGenerator;
import fluent.dsl.parser.BuilderParser;
import fluent.dsl.parser.DslParser;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"fluent.dsl.Dsl"})
public class DslAnnotationProcessor
extends AbstractProcessor {
    private final Set<ElementKind> modelTypes = new HashSet<ElementKind>(Arrays.asList(ElementKind.INTERFACE, ElementKind.CLASS, ElementKind.PARAMETER));

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ModelFactoryImpl modelFactory = new ModelFactoryImpl(this.processingEnv.getElementUtils(), this.processingEnv.getTypeUtils());
        for (Element element : roundEnv.getElementsAnnotatedWith(Dsl.class)) {
            switch (element.getKind()) {
                case INTERFACE: 
                case CLASS: {
                    this.processBinding(element, new DslParser((ModelFactory)modelFactory));
                    break;
                }
                case FIELD: 
                case PARAMETER: {
                    this.processBuilder(element, new BuilderParser((ModelFactory)modelFactory));
                }
            }
        }
        return true;
    }

    private void processBinding(Element element, DslParser factory) {
        try {
            TypeModel model = factory.parseModel(element);
            DslGenerator.generateFrom(this.processingEnv.getFiler().createSourceFile(model.superClass().rawType().fullName(), new Element[0]).openWriter(), element.getAnnotation(Dsl.class).useVarargs(), generator -> generator.generateDsl(model));
        }
        catch (Throwable throwable) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unable to generate DSL for " + element + ": " + throwable, element);
        }
    }

    private void processBuilder(Element element, BuilderParser parser) {
        try {
            TypeModel model = parser.parseModel(element);
            DslGenerator.generateFrom(this.processingEnv.getFiler().createSourceFile(model.rawType().fullName(), new Element[0]).openWriter(), element.getAnnotation(Dsl.class).useVarargs(), generator -> generator.generateBuilder(model));
        }
        catch (Throwable throwable) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unable to generate DSL for " + element + ": " + throwable, element);
        }
    }
}

