/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.parser;

import fluent.api.model.MethodModel;
import fluent.api.model.ModelFactory;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.dsl.Constant;
import fluent.dsl.Dsl;
import fluent.dsl.model.DslUtils;
import fluent.dsl.parser.InitialState;
import fluent.dsl.parser.State;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;

public class DslParser {
    private final ModelFactory factory;

    public DslParser(ModelFactory factory) {
        this.factory = factory;
    }

    public TypeModel parseModel(Element element) {
        TypeModel model = this.factory.type(element);
        Dsl dsl = element.getAnnotation(Dsl.class);
        String packageName = DslUtils.override(dsl.packageName(), model.packageName());
        String dslName = DslUtils.override(dsl.className(), model.rawType().simpleName() + "Dsl");
        VarModel source = this.factory.parameter(model, dsl.parameterName());
        TypeModel dslType = (TypeModel)this.factory.type(packageName, dslName).typeParameters(model.typeParameters());
        MethodModel factoryMethod = ((MethodModel)this.factory.method(Arrays.asList(Modifier.PUBLIC, Modifier.STATIC), dsl.factoryMethod(), Collections.singletonList(source)).typeParameters(model.typeParameters())).returnType(dslType);
        dslType.methods().add(factoryMethod);
        this.parseMethods(element, InitialState.start(this.factory, dslType, Modifier.PUBLIC), source);
        return ((TypeModel)this.factory.type("", "Delegate").typeParameters(model.typeParameters())).superClass(dslType).methods(Collections.singletonList(this.factory.method(dsl.delegateMethod(), new VarModel[0]).returnType(dslType)));
    }

    public void parseMethods(Element element, State state, VarModel impl) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            state = this.annotation(state, annotationMirror);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(element.getEnclosedElements())) {
            this.parseParameters(executableElement, state.method(DslUtils.from(executableElement)), impl);
        }
    }

    public void parseParameters(ExecutableElement method, State state, VarModel impl) {
        for (VariableElement variableElement : method.getParameters()) {
            for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                state = this.annotation(state, annotationMirror);
            }
            state = state.parameter(this.factory.parameter(variableElement));
        }
        for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
            state = this.annotation(state, annotationMirror);
        }
        MethodModel methodModel = this.factory.method(method);
        state.body(methodModel.returnType(), this.factory.statementModel(impl, methodModel));
    }

    public State annotation(State state, AnnotationMirror annotation) {
        Element element = annotation.getAnnotationType().asElement();
        if (Objects.nonNull(element.getAnnotation(Constant.class))) {
            return state.constant(this.factory.constant(DslUtils.from(element)));
        }
        if (Objects.nonNull(DslUtils.getDsl(element))) {
            return state.keyword(DslUtils.from(element), this.aliases(element));
        }
        return state;
    }

    private Set<String> aliases(Element element) {
        return element.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.ANNOTATION_TYPE).map(DslUtils::from).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

