/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.parser;

import fluent.api.model.MethodModel;
import fluent.api.model.ModelFactory;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.dsl.Dsl;
import fluent.dsl.model.DslUtils;
import fluent.dsl.parser.InitialState;
import fluent.dsl.parser.State;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;

public class BuilderParser {
    private final ModelFactory factory;

    public BuilderParser(ModelFactory factory) {
        this.factory = factory;
    }

    public TypeModel parseModel(Element element) {
        TypeModel model = this.factory.parameter((VariableElement)element).type();
        Dsl dsl = element.getAnnotation(Dsl.class);
        String packageName = DslUtils.override(dsl.packageName(), model.packageName());
        String dslName = DslUtils.override(dsl.className(), model.rawType().simpleName() + "With");
        TypeModel dslModel = this.factory.type(packageName, dslName);
        TypeModel builderModel = (TypeModel)this.factory.type("", "Builder").typeParameters(model.typeParameters());
        TypeModel builderImpl = (TypeModel)this.factory.type("", "BuilderImpl").typeParameters(builderModel.typeParameters());
        VarModel object = this.factory.parameter(model, "object");
        builderImpl.interfaces().add(builderModel);
        builderImpl.fields().put(object.name(), object);
        Element typeElement = ((DeclaredType)element.asType()).asElement();
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(typeElement.getEnclosedElements());
        boolean hasSetters = ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().anyMatch(DslUtils::isSetter);
        if (hasSetters || constructors.size() > 1) {
            this.readConstructors(typeElement, InitialState.start(this.factory, dslModel, Modifier.PUBLIC, Modifier.STATIC), c -> this.builderConstructor((MethodModel)c, builderImpl), builderModel);
            State state = InitialState.start(this.factory, builderModel, Modifier.PUBLIC);
            VarModel thisModel = this.factory.parameter(builderImpl, "this");
            for (ExecutableElement method : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                if (!DslUtils.isSetter(method)) continue;
                state.keyword(DslUtils.unCapitalize(method.getSimpleName().toString().substring(3))).parameter(this.factory.parameter(method.getParameters().get(0))).body(builderModel, this.factory.statementModel(object, this.factory.method(method)), this.factory.statementModel(thisModel, null));
            }
            dslModel.nestedClasses().add(builderImpl);
            MethodModel buildMethod = this.factory.method("build", new VarModel[0]).returnType(model);
            buildMethod.body().add(this.factory.statementModel(object, null));
            builderModel.methods().add(buildMethod);
        } else if (constructors.size() == 1 && constructors.get(0).getParameters().size() > 0) {
            this.readConstructors(typeElement, InitialState.start(this.factory, dslModel, Modifier.PUBLIC, Modifier.STATIC), Function.identity(), model);
        }
        return dslModel;
    }

    private String constructorCall(MethodModel constructor) {
        return "new " + constructor.returnType().fullName() + "(" + constructor.parameters().stream().map(VarModel::name).collect(Collectors.joining(", ")) + ")";
    }

    public void readConstructors(Element element, State state, Function<MethodModel, MethodModel> constructorFactory, TypeModel returnType) {
        for (ExecutableElement constructor : ElementFilter.constructorsIn(element.getEnclosedElements())) {
            this.readMethodParameters(constructor, state, constructorFactory, returnType);
        }
    }

    public void readMethodParameters(ExecutableElement method, State state, Function<MethodModel, MethodModel> constructor, TypeModel returnType) {
        for (VariableElement variableElement : method.getParameters()) {
            state = state.keyword(DslUtils.from(variableElement)).parameter(this.factory.parameter(variableElement));
        }
        state.body(returnType, this.factory.statementModel(null, constructor.apply(this.factory.method(method))));
    }

    public MethodModel builderConstructor(MethodModel constructor, TypeModel typeModel) {
        return this.factory.constructor(typeModel, new VarModel[]{this.factory.parameter(constructor.returnType(), this.constructorCall(constructor))});
    }
}

