/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.model;

import fluent.api.model.GenericModel;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.dsl.Dsl;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;

public final class DslUtils {
    public static String capitalize(String string) {
        return string.isEmpty() ? string : string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String unCapitalize(String string) {
        return string.isEmpty() ? string : string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    public static String simpleName(TypeModel model) {
        return model.isArray() ? DslUtils.simpleName(model.componentType()) + "Array" : model.rawType().simpleName();
    }

    public static String generic(GenericModel<?> model) {
        return model.typeParameters().isEmpty() ? "" : model.typeParameters().stream().map(TypeModel::fullName).collect(Collectors.joining(", ", "<", ">"));
    }

    public static void traverse(TypeModel t, List<TypeModel> out) {
        if (t.isTypeVariable()) {
            out.add(t);
        } else {
            t.typeParameters().forEach(p -> DslUtils.traverse(p, out));
        }
    }

    public static List<TypeModel> usedTypeParameters(List<VarModel> parameters) {
        ArrayList<TypeModel> out = new ArrayList<TypeModel>();
        parameters.stream().map(VarModel::type).forEach(t -> DslUtils.traverse(t, out));
        return out;
    }

    public static String override(String configuredValue, String defaultValue) {
        return configuredValue.isEmpty() ? defaultValue : configuredValue;
    }

    public static boolean isSetter(ExecutableElement method) {
        return !method.getModifiers().contains((Object)Modifier.STATIC) && method.getSimpleName().toString().startsWith("set") && method.getParameters().size() == 1;
    }

    public static boolean isGetter(ExecutableElement method) {
        return !method.getModifiers().contains((Object)Modifier.STATIC) && method.getSimpleName().toString().startsWith("get") && method.getParameters().size() == 0;
    }

    public static Dsl getDsl(Element element) {
        Dsl dsl = element.getAnnotation(Dsl.class);
        if (Objects.nonNull(dsl)) {
            return dsl;
        }
        Element enclosingElement = element.getEnclosingElement();
        if (Objects.nonNull(enclosingElement)) {
            return DslUtils.getDsl(enclosingElement);
        }
        try {
            Element packageElement = (Element)element.getClass().getField("owner").get(element);
            if (Objects.nonNull(packageElement)) {
                return DslUtils.getDsl(packageElement);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String from(Element element) {
        return element.getSimpleName().toString();
    }
}

