/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.parser;

import fluent.api.model.AnnotationModel;
import fluent.api.model.MethodModel;
import fluent.api.model.ModelFactory;
import fluent.api.model.StatementModel;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.dsl.model.DslUtils;
import fluent.dsl.parser.ParserState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;

public class ParserContext {
    private final ModelFactory factory;
    private final TypeModel dsl;
    private final VarModel impl;

    public ParserContext(ModelFactory factory, TypeModel dsl, VarModel impl) {
        this.factory = factory;
        this.dsl = dsl;
        this.impl = impl;
    }

    final class Node {
        private final Map<String, Node> nodes = new LinkedHashMap<String, Node>();
        private final Collection<Modifier> modifiers;
        private final TypeModel typeModel;

        private Node(Collection<Modifier> modifiers, TypeModel typeModel) {
            this.modifiers = modifiers;
            this.typeModel = typeModel;
        }

        public Node add(TypeModel typeModel, String className, String methodName, List<String> aliases, List<VarModel> parameters, StatementModel[] bindingModel) {
            return this.nodes.computeIfAbsent(className, key -> {
                List typeParameters = this.typeModel.typeParameters();
                LinkedHashMap map = new LinkedHashMap();
                typeParameters.forEach(p -> map.put(p.fullName(), p));
                DslUtils.usedTypeParameters(parameters).forEach(t -> map.put(t.fullName(), t));
                ArrayList newParameters = new ArrayList(map.values());
                List methodTypeParameters = newParameters.subList(typeParameters.size(), newParameters.size());
                MethodModel methodModel = ((MethodModel)ParserContext.this.factory.method(this.modifiers, methodName, parameters).returnType(Objects.isNull(typeModel) ? (TypeModel)ParserContext.this.factory.type("", className).typeParameters(newParameters) : typeModel).typeParameters(methodTypeParameters)).owner(this.typeModel);
                methodModel.metadata().put("aliases", aliases);
                methodModel.body().addAll(Arrays.asList(bindingModel));
                this.typeModel.methods().add(methodModel);
                return new Node(Collections.singleton(Modifier.PUBLIC), methodModel.returnType());
            });
        }
    }

    public class DecideState
    extends KeywordState
    implements ParserState {
        private final String methodName;

        public DecideState(Node node, String name, boolean useVarargs) {
            super(node, name, Collections.emptyList(), useVarargs);
            this.methodName = name;
        }

        @Override
        public ParserState keyword(String name, List<String> aliases, boolean useVarargs) {
            return new KeywordState(this.node, name, aliases, useVarargs);
        }

        @Override
        public ParserState constant(String name) {
            return this.keyword(this.methodName, Collections.emptyList(), this.useVarargs).constant(name);
        }

        @Override
        public ParserState parameter(VariableElement parameterModel) {
            return this.keyword(this.methodName, Collections.emptyList(), this.useVarargs).parameter(parameterModel);
        }
    }

    public class KeywordState
    extends AbstractState {
        private final String methodName;
        private final List<String> aliases;
        private final List<VarModel> parameters;
        final boolean useVarargs;

        public KeywordState(Node node, String name, List<String> aliases, boolean useVarargs) {
            super(node);
            this.parameters = new ArrayList<VarModel>();
            this.methodName = name;
            this.aliases = aliases;
            this.useVarargs = useVarargs;
        }

        @Override
        public ParserState constant(String name) {
            VarModel parameter = ParserContext.this.factory.parameter(ParserContext.this.factory.type("", name), name);
            ParserContext.this.dsl.fields().add(parameter);
            this.parameters.add(parameter);
            return this;
        }

        @Override
        public ParserState parameter(VariableElement parameterModel) {
            this.parameters.add(ParserContext.this.factory.parameter(parameterModel));
            return this;
        }

        @Override
        public void bind(MethodModel body) {
            this.bind(body, body.returnType());
        }

        @Override
        public void bind(MethodModel body, TypeModel returnType) {
            StatementModel binding = ParserContext.this.factory.statementModel(ParserContext.this.impl, body);
            this.finish(returnType, binding);
        }

        @Override
        Node finish(TypeModel returnTypeModel, StatementModel ... bindingModel) {
            String className = DslUtils.capitalize(this.methodName) + this.parameters.stream().map(p -> DslUtils.simpleName(p.type())).collect(Collectors.joining());
            return this.node.add(returnTypeModel, className, this.methodName, this.aliases, this.parameters, bindingModel);
        }
    }

    public class InitialState
    extends AbstractState {
        public InitialState(Modifier ... modifiers) {
            super(new Node(Arrays.asList(modifiers), ParserContext.this.dsl));
        }

        @Override
        public ParserState constant(String name) {
            return this;
        }

        @Override
        public ParserState parameter(VariableElement parameterModel) {
            return this;
        }

        @Override
        public void bind(MethodModel method) {
        }

        @Override
        public void bind(MethodModel method, TypeModel returnType) {
        }

        @Override
        Node finish(TypeModel returnTypeModel, StatementModel ... bindingModel) {
            return this.node;
        }
    }

    public abstract class AbstractState
    implements ParserState {
        final Node node;

        public AbstractState(Node node) {
            this.node = node;
        }

        @Override
        public ParserState annotation(AnnotationModel annotationModel) {
            return this;
        }

        @Override
        public ParserState keyword(String name, List<String> aliases, boolean useVarargs) {
            return new KeywordState(this.finish(null, new StatementModel[0]), name, aliases, useVarargs);
        }

        @Override
        public ParserState method(String name) {
            return new DecideState(this.finish(null, new StatementModel[0]), name, false);
        }

        abstract Node finish(TypeModel var1, StatementModel ... var2);
    }
}

