/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.parser;

import fluent.api.model.MethodModel;
import fluent.api.model.ModelFactory;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.dsl.Constant;
import fluent.dsl.Dsl;
import fluent.dsl.model.DslUtils;
import fluent.dsl.parser.ParserContext;
import fluent.dsl.parser.ParserState;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;

public class DslParser {
    private final ModelFactory factory;

    public DslParser(ModelFactory factory) {
        this.factory = factory;
    }

    public TypeModel parseModel(Element element) {
        TypeModel model = this.factory.type(element);
        Dsl dsl = element.getAnnotation(Dsl.class);
        String packageName = DslUtils.override(dsl.packageName(), model.packageName());
        String dslName = DslUtils.override(dsl.className(), model.rawType().simpleName() + "Dsl");
        VarModel source = this.factory.parameter(model, dsl.parameterName());
        TypeModel dslType = (TypeModel)this.factory.type(packageName, dslName).typeParameters(model.typeParameters());
        MethodModel factoryMethod = ((MethodModel)this.factory.method(Arrays.asList(Modifier.PUBLIC, Modifier.STATIC), dsl.factoryMethod(), Collections.singletonList(source)).typeParameters(model.typeParameters())).returnType(dslType);
        dslType.methods().add(factoryMethod);
        ParserState prefix = this.start(dslType, source);
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            prefix = this.annotationState(prefix, annotationMirror);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(element.getEnclosedElements())) {
            ParserState state = prefix.method(executableElement.getSimpleName().toString());
            for (VariableElement variableElement : executableElement.getParameters()) {
                for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                    state = this.annotationState(state, annotationMirror);
                }
                state = state.parameter(variableElement);
            }
            for (AnnotationMirror annotationMirror : executableElement.getAnnotationMirrors()) {
                state = this.annotationState(state, annotationMirror);
            }
            state.bind(this.factory.method(executableElement));
        }
        return ((TypeModel)this.factory.type("", "Delegate").typeParameters(model.typeParameters())).superClass(dslType).methods(Collections.singletonList(this.factory.method(dsl.delegateMethod(), new VarModel[0]).returnType(dslType)));
    }

    private ParserState annotationState(ParserState prev, AnnotationMirror annotation) {
        Element element = annotation.getAnnotationType().asElement();
        String name = element.getSimpleName().toString();
        if (Objects.nonNull(element.getAnnotation(Constant.class))) {
            return prev.constant(name);
        }
        Dsl dsl = DslParser.getDsl(element);
        if (Objects.nonNull(dsl)) {
            return prev.keyword(name, element.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.ANNOTATION_TYPE).map(e -> e.getSimpleName().toString()).collect(Collectors.toList()), dsl.useVarargs());
        }
        return prev;
    }

    private static Dsl getDsl(Element element) {
        Dsl dsl = element.getAnnotation(Dsl.class);
        if (Objects.nonNull(dsl)) {
            return dsl;
        }
        Element enclosingElement = element.getEnclosingElement();
        if (Objects.nonNull(enclosingElement)) {
            return DslParser.getDsl(enclosingElement);
        }
        try {
            Element packageElement = (Element)element.getClass().getField("owner").get(element);
            if (Objects.nonNull(packageElement)) {
                return DslParser.getDsl(packageElement);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        return null;
    }

    private ParserState start(TypeModel model, VarModel impl) {
        ParserContext parserContext = new ParserContext(this.factory, model, impl);
        parserContext.getClass();
        return parserContext.new ParserContext.InitialState(new Modifier[0]);
    }
}

