/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.parser;

import fluent.api.model.MethodModel;
import fluent.api.model.ModelFactory;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.dsl.Dsl;
import fluent.dsl.model.DslUtils;
import fluent.dsl.parser.ParserContext;
import fluent.dsl.parser.ParserState;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;

public class BuilderParser {
    private final ModelFactory factory;

    public BuilderParser(ModelFactory factory) {
        this.factory = factory;
    }

    public TypeModel parseModel(Element element) {
        TypeModel model = this.factory.parameter((VariableElement)element).type();
        Dsl dsl = element.getAnnotation(Dsl.class);
        String packageName = DslUtils.override(dsl.packageName(), model.packageName());
        String dslName = DslUtils.override(dsl.className(), model.rawType().simpleName() + "With");
        TypeModel dslModel = this.factory.type(packageName, dslName);
        TypeModel builderModel = (TypeModel)this.factory.type("", "Builder").typeParameters(model.typeParameters());
        TypeModel builderImpl = (TypeModel)this.factory.type("", "BuilderImpl").typeParameters(builderModel.typeParameters());
        builderImpl.interfaces().add(builderModel);
        ParserState start = this.start(dslModel, null, Modifier.STATIC);
        Element typeElement = ((DeclaredType)element.asType()).asElement();
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(typeElement.getEnclosedElements());
        List setters = ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().filter(this::isSetter).collect(Collectors.toList());
        boolean isBuilder = constructors.size() > 1 || !setters.isEmpty();
        VarModel object = this.factory.parameter(model, "object");
        if (isBuilder) {
            dslModel.nestedClasses().add(builderImpl);
            builderImpl.fields().add(object);
        }
        for (ExecutableElement constructor : constructors) {
            ParserState state = start;
            for (VariableElement variableElement : constructor.getParameters()) {
                state = state.keyword(variableElement.getSimpleName().toString(), Collections.emptyList(), true).parameter(variableElement);
            }
            MethodModel constructorModel = this.factory.method(constructor);
            if (isBuilder) {
                state.bind(this.factory.constructor(builderImpl, new VarModel[]{this.factory.parameter(model, this.constructorCall(constructorModel))}));
                continue;
            }
            state.bind(constructorModel);
        }
        ParserState builder = this.start(builderModel, object, new Modifier[0]);
        for (ExecutableElement setter : setters) {
            builder.keyword(DslUtils.unCapitalize(setter.getSimpleName().toString().substring(3)), Collections.emptyList(), true).parameter(setter.getParameters().get(0)).bind(this.factory.method(setter), builderModel);
        }
        return dslModel;
    }

    private boolean isSetter(ExecutableElement element) {
        return element.getSimpleName().toString().startsWith("set") && element.getParameters().size() == 1;
    }

    private ParserState start(TypeModel model, VarModel object, Modifier ... modifiers) {
        ParserContext parserContext = new ParserContext(this.factory, model, object);
        parserContext.getClass();
        return new ParserContext.InitialState(parserContext, modifiers);
    }

    private String constructorCall(MethodModel constructor) {
        return "new " + constructor.returnType().fullName() + "(" + constructor.parameters().stream().map(VarModel::name).collect(Collectors.joining(", ")) + ")";
    }
}

