/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.model;

import fluent.api.model.GenericModel;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class DslUtils {
    public static String capitalize(String string) {
        return string.isEmpty() ? string : string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String unCapitalize(String string) {
        return string.isEmpty() ? string : string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    public static String simpleName(TypeModel model) {
        return model.isArray() ? DslUtils.simpleName(model.componentType()) + "Array" : model.rawType().simpleName();
    }

    public static String generic(GenericModel<?> model) {
        return model.typeParameters().isEmpty() ? "" : model.typeParameters().stream().map(TypeModel::fullName).collect(Collectors.joining(", ", "<", ">"));
    }

    public static void traverse(TypeModel t, List<TypeModel> out) {
        if (t.isTypeVariable()) {
            out.add(t);
        } else {
            t.typeParameters().forEach(p -> DslUtils.traverse(p, out));
        }
    }

    public static List<TypeModel> usedTypeParameters(List<VarModel> parameters) {
        ArrayList<TypeModel> out = new ArrayList<TypeModel>();
        parameters.stream().map(VarModel::type).forEach(t -> DslUtils.traverse(t, out));
        return out;
    }

    public static String override(String configuredValue, String defaultValue) {
        return configuredValue.isEmpty() ? defaultValue : configuredValue;
    }
}

