/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.generator;

import fluent.api.model.MethodModel;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.dsl.model.DslUtils;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class DslGenerator {
    private static final String tab = "\t";
    private final PrintWriter source;
    private final String prefix;
    private final boolean useVarargs;
    private final Set<TypeModel> generated = new HashSet<TypeModel>();

    private DslGenerator(PrintWriter source, String prefix, boolean useVarargs) {
        this.source = source;
        this.prefix = prefix;
        this.useVarargs = useVarargs;
    }

    private DslGenerator indent() {
        return new DslGenerator(this.source, this.prefix + tab, this.useVarargs);
    }

    private void println(String line) {
        this.source.println(this.prefix + line);
    }

    private void println() {
        this.source.println();
    }

    public static void generateFrom(Writer writer, boolean useVarargs, Consumer<DslGenerator> consumer) {
        try (PrintWriter source = new PrintWriter(writer);){
            consumer.accept(new DslGenerator(source, "", useVarargs));
        }
    }

    public void generateDsl(TypeModel delegateModel) {
        DslGenerator nested = this.indent();
        TypeModel model = delegateModel.superClass();
        this.println("package " + model.packageName() + ";");
        this.println();
        this.println("import javax.annotation.Generated;");
        this.println("import fluent.api.Start;");
        this.println("import fluent.api.End;");
        this.println();
        this.println("@Generated(\"Generated DSL class\")");
        this.println("public interface " + model.simpleName() + " {");
        model.fields().forEach(nested::generateConstant);
        this.println();
        nested.generateInterfaceContent(model);
        this.println();
        nested.generateDelegate(delegateModel);
        this.println();
        model.fields().forEach(nested::generateConstantClass);
        this.println("}");
    }

    public void generateBuilder(TypeModel model) {
        DslGenerator nested = this.indent();
        this.println("package " + model.packageName() + ";");
        this.println();
        this.println("import javax.annotation.Generated;");
        this.println("import fluent.api.Start;");
        this.println("import fluent.api.End;");
        this.println();
        this.println("@Generated(\"Generated DSL class\")");
        this.println("public interface " + model.simpleName() + " {");
        this.println();
        nested.generateInterfaceContent(model);
        this.println();
        model.nestedClasses().stream().flatMap(impl -> impl.interfaces().stream()).forEach(nested::generateInterface);
        model.nestedClasses().forEach(nested::generateBuilderClass);
        this.println("}");
    }

    private void generateConstant(VarModel constant) {
        this.println("public static final " + constant.type().simpleName() + " " + constant.name() + " = new " + constant.type().simpleName() + "();");
    }

    private void generateConstantClass(VarModel constant) {
        this.println();
        this.println("public static final class " + constant.type().simpleName() + "{");
        this.indent().println("private " + constant.type().simpleName() + "() {}");
        this.println("}");
    }

    private void generateDelegate(TypeModel delegateModel) {
        TypeModel model = delegateModel.superClass();
        this.println("public interface Delegate" + DslUtils.generic(model) + " extends " + model.simpleName() + " {");
        DslGenerator indent = this.indent();
        indent.generateSignature((MethodModel)delegateModel.methods().get(0));
        model.methods().stream().filter(m -> !m.modifiers().isStatic()).forEach(keyword -> indent.generateDelegateMethod((MethodModel)keyword, (MethodModel)delegateModel.methods().get(0)));
        this.println("}");
    }

    private void generateDelegateMethod(MethodModel model, MethodModel delegate) {
        this.println("default " + DslUtils.generic(model) + " " + model.returnType().fullName() + " " + model.name() + "(" + this.parameters(model) + ") {");
        this.indent().println(this.returnType(model) + delegate.name() + "()." + model.name() + "(" + this.args(model) + ");");
        this.println("}");
    }

    private void generateInterfaceContent(TypeModel model) {
        this.generated.add(model);
        model.methods().forEach(this::generateSignature);
        model.methods().stream().filter(kw -> kw.body().isEmpty()).map(MethodModel::returnType).filter(t -> !this.generated.contains(t)).forEach(this::generateInterface);
    }

    private void generateInterface(TypeModel model) {
        this.println();
        this.println("public interface " + model.simpleName() + " {");
        this.indent().generateInterfaceContent(model);
        this.println("}");
    }

    private void generateBuilderClass(TypeModel model) {
        DslGenerator nested = this.indent();
        DslGenerator nested2 = nested.indent();
        this.println();
        this.println("public class " + model.simpleName() + " implements " + model.interfaces().stream().map(TypeModel::fullName).collect(Collectors.joining(", ")) + " {");
        model.fields().forEach(f -> nested.println("private final " + f.type().fullName() + " " + f.name() + ";"));
        nested.println("" + model.rawType().simpleName() + "(" + model.fields().stream().map(v -> v.type().fullName() + " " + v.name()).collect(Collectors.joining()) + ") {");
        model.fields().forEach(f -> nested2.println("this." + f.name() + " = " + f.name() + ";"));
        nested.println("}");
        model.interfaces().stream().flatMap(i -> i.methods().stream()).forEach(m -> {
            nested.println("public " + model.fullName() + " " + m.name() + "(" + this.parameters((MethodModel)m) + ") {");
            m.body().forEach(s -> nested2.println(s.toString()));
            nested2.println("return this;");
            nested.println("}");
        });
        nested.println("public " + ((VarModel)model.fields().get(0)).type().fullName() + " build() {");
        nested2.println("return " + ((VarModel)model.fields().get(0)).name() + ";");
        nested.println("}");
        this.println("}");
    }

    private void generateSignature(MethodModel model) {
        if (model.modifiers().isStatic()) {
            this.generateMethod(model);
        } else {
            this.println((model.body().isEmpty() ? "@Start(\"Unterminated sentence.\") " : "@End ") + DslUtils.generic(model) + " " + model.returnType().fullName() + " " + model.name() + "(" + this.parameters(model) + ");");
            model.metadata().getOrDefault("aliases", Collections.emptyList()).forEach(alias -> {
                this.println("default " + DslUtils.generic(model) + " " + model.returnType().fullName() + " " + alias + "(" + this.parameters(model) + ") {");
                this.indent().println(this.returnType(model) + model.name() + "(" + this.args(model) + ");");
                this.println("}");
            });
        }
    }

    private String returnType(MethodModel model) {
        return model.returnsValue() ? "return " : "";
    }

    private void generateMethod(MethodModel model) {
        this.println("public " + (model.modifiers().isStatic() ? "static " : "") + DslUtils.generic(model) + " " + model.returnType().fullName() + " " + model.name() + "(" + this.parameters(model) + ") {");
        DslGenerator nested = this.indent();
        if (model.body().isEmpty()) {
            nested.generateReturnAnonymousClass(model.returnType());
        } else {
            model.body().forEach(statementModel -> nested.println(statementModel.toString()));
        }
        this.println("}");
    }

    private void generateReturnAnonymousClass(TypeModel model) {
        this.println("return new " + model.simpleName() + "() {");
        DslGenerator indent = this.indent();
        model.methods().stream().filter(m -> !m.modifiers().isStatic()).forEach(indent::generateMethod);
        this.println("};");
    }

    private String parameters(MethodModel model) {
        List collect = model.parameters().stream().map(p -> p.type().fullName() + " " + p.name()).collect(Collectors.toList());
        if (this.useVarargs && !collect.isEmpty()) {
            collect.set(collect.size() - 1, ((String)collect.get(collect.size() - 1)).replace("[] ", "... "));
        }
        return String.join((CharSequence)", ", collect);
    }

    private String args(MethodModel model) {
        return model.parameters().stream().map(VarModel::name).collect(Collectors.joining(", "));
    }
}

