/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.processor;

import fluent.api.model.AnnotationModel;
import fluent.api.model.MethodModel;
import fluent.api.model.StatementModel;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.dsl.model.DslModel;
import fluent.dsl.model.DslModelFactory;
import fluent.dsl.model.DslUtils;
import fluent.dsl.processor.DslParser;
import fluent.dsl.processor.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public class DslParserState {
    private final DslModelFactory factory;
    private final DslModel dsl;
    private final VarModel impl;

    public DslParserState(DslModelFactory factory, DslModel dsl, VarModel impl) {
        this.factory = factory;
        this.dsl = dsl;
        this.impl = impl;
    }

    public class DecideState
    extends KeywordState
    implements DslParser.State {
        private final Node node;
        private final String methodName;

        public DecideState(Node node, String name, boolean useVarargs) {
            super(node, name, Collections.emptyList(), useVarargs);
            this.node = node;
            this.methodName = name;
        }

        @Override
        public DslParser.State keyword(String name, List<String> aliases, boolean useVarargs) {
            return new KeywordState(this.node, name, aliases, useVarargs);
        }

        @Override
        public DslParser.State constant(String name) {
            return this.keyword(this.methodName, Collections.emptyList(), this.useVarargs).constant(name);
        }

        @Override
        public DslParser.State parameter(VariableElement parameterModel) {
            return this.keyword(this.methodName, Collections.emptyList(), this.useVarargs).parameter(parameterModel);
        }
    }

    public class KeywordState
    implements DslParser.State {
        private final Node node;
        private final String methodName;
        private final List<String> aliases;
        private final List<VarModel> parameters = new ArrayList<VarModel>();
        final boolean useVarargs;

        public KeywordState(Node node, String name, List<String> aliases, boolean useVarargs) {
            this.node = node;
            this.methodName = name;
            this.aliases = aliases;
            this.useVarargs = useVarargs;
        }

        @Override
        public DslParser.State annotation(AnnotationModel annotationModel) {
            return this;
        }

        @Override
        public DslParser.State keyword(String name, List<String> aliases, boolean useVarargs) {
            return new KeywordState(this.finish(null, new StatementModel[0]), name, aliases, useVarargs);
        }

        @Override
        public DslParser.State method(String name) {
            return new DecideState(this.finish(null, new StatementModel[0]), name, false);
        }

        @Override
        public DslParser.State constant(String name) {
            this.parameters.add(DslParserState.this.dsl.addConstant(DslParserState.this.factory.parameter(Collections.emptyList(), DslParserState.this.factory.type(Collections.emptyList(), "", name), name)));
            return this;
        }

        @Override
        public DslParser.State parameter(VariableElement parameterModel) {
            this.parameters.add(DslParserState.this.factory.parameter(parameterModel));
            return this;
        }

        @Override
        public void bind(ExecutableElement method) {
            MethodModel body = DslParserState.this.factory.method(method);
            StatementModel binding = DslParserState.this.factory.statementModel(DslParserState.this.impl, body);
            this.finish(body.returnType(), binding);
        }

        private Node finish(TypeModel returnTypeModel, StatementModel ... bindingModel) {
            String className = DslUtils.capitalize(this.methodName) + this.parameters.stream().map(p -> DslUtils.simpleName(p.type())).collect(Collectors.joining());
            return this.node.add(returnTypeModel, className, this.methodName, this.aliases, this.parameters, bindingModel);
        }
    }

    public class InitialState
    implements DslParser.State {
        Node node;

        public InitialState(Node node) {
            this.node = node;
        }

        @Override
        public DslParser.State annotation(AnnotationModel annotationModel) {
            return this;
        }

        @Override
        public DslParser.State keyword(String name, List<String> aliases, boolean useVarargs) {
            return new KeywordState(this.node, name, aliases, useVarargs);
        }

        @Override
        public DslParser.State method(String name) {
            return new DecideState(this.node, name, false);
        }

        @Override
        public DslParser.State constant(String name) {
            return this;
        }

        @Override
        public DslParser.State parameter(VariableElement parameterModel) {
            return this;
        }

        @Override
        public void bind(ExecutableElement method) {
        }
    }
}

