/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.generator;

import fluent.api.model.GenericModel;
import fluent.api.model.MethodModel;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.dsl.model.DslModel;
import fluent.dsl.model.DslUtils;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DslGenerator {
    private static final String tab = "\t";
    private final PrintWriter source;
    private final String prefix;
    private final boolean useVarargs;

    private DslGenerator(PrintWriter source, String prefix, boolean useVarargs) {
        this.source = source;
        this.prefix = prefix;
        this.useVarargs = useVarargs;
    }

    private DslGenerator indent() {
        return new DslGenerator(this.source, this.prefix + tab, this.useVarargs);
    }

    private void println(String line) {
        this.source.println(this.prefix + line);
    }

    private void println() {
        this.source.println();
    }

    public static void generateFrom(Writer writer, DslModel model, boolean useVarargs) {
        try (PrintWriter source = new PrintWriter(writer);){
            new DslGenerator(source, "", useVarargs).generateDsl(model);
        }
    }

    private void generateDsl(DslModel model) {
        DslGenerator nested = this.indent();
        this.println("package " + model.type().packageName() + ";");
        this.println();
        this.println("import fluent.api.Start;");
        this.println("import fluent.api.End;");
        this.println();
        this.println();
        this.println("public interface " + model.type().simpleName() + "{");
        model.constants().forEach(nested::generateConstant);
        this.println();
        nested.generateMethod("static ", model.factory());
        this.println();
        nested.generateInterfaceContent(model.type());
        this.println();
        nested.generateDelegate(model);
        this.println();
        model.constants().forEach(nested::generateConstantClass);
        this.println("}");
    }

    private void generateConstant(VarModel constant) {
        this.println("public static final " + constant.type().simpleName() + " " + constant.name() + " = new " + constant.type().simpleName() + "();");
    }

    private void generateConstantClass(VarModel constant) {
        this.println();
        this.println("public static final class " + constant.type().simpleName() + "{");
        this.indent().println("private " + constant.type().simpleName() + "() {}");
        this.println("}");
    }

    private void generateDelegate(DslModel model) {
        this.println("public interface Delegate" + DslUtils.generic((GenericModel)model.type()) + " extends " + model.type().simpleName() + " {");
        DslGenerator indent = this.indent();
        indent.generateSignature(model.delegate());
        model.type().methods().forEach(keyword -> indent.generateDelegateMethod((MethodModel)keyword, model.delegate()));
        this.println("}");
    }

    private void generateDelegateMethod(MethodModel model, MethodModel delegate) {
        this.println("default " + model.returnType().fullName() + " " + model.name() + "(" + this.parameters(model) + ") {");
        this.indent().println(this.returnType(model) + delegate.name() + "()." + model.name() + "(" + this.args(model) + ");");
        this.println("}");
    }

    private void generateInterfaceContent(TypeModel model) {
        model.methods().forEach(this::generateSignature);
        model.methods().stream().filter(kw -> kw.body().isEmpty()).map(MethodModel::returnType).forEach(this::generateInterface);
    }

    private void generateInterface(TypeModel model) {
        this.println();
        this.println("public interface " + model.simpleName() + " {");
        this.indent().generateInterfaceContent(model);
        this.println("}");
    }

    private void generateSignature(MethodModel model) {
        this.println((model.body().isEmpty() ? "@Start(\"Unterminated sentence.\") " : "@End ") + DslUtils.generic((GenericModel)model) + " " + model.returnType().fullName() + " " + model.name() + "(" + this.parameters(model) + ");");
        model.metadata().getOrDefault("aliases", Collections.emptyList()).forEach(alias -> {
            this.println("default " + DslUtils.generic((GenericModel)model) + " " + model.returnType() + " " + alias + "(" + this.parameters(model) + ") {");
            this.indent().println(this.returnType(model) + model.name() + "(" + this.args(model) + ");");
            this.println("}");
        });
    }

    private String returnType(MethodModel model) {
        return model.returnsValue() ? "return " : "";
    }

    private void generateMethod(String modifiers, MethodModel model) {
        this.println(modifiers + DslUtils.generic((GenericModel)model) + " " + model.returnType().simpleName() + " " + model.name() + "(" + this.parameters(model) + ") {");
        DslGenerator nested = this.indent();
        if (model.body().isEmpty()) {
            nested.generateReturnAnonymousClass(model.returnType());
        } else {
            model.body().forEach(statementModel -> nested.println(statementModel.toString()));
        }
        this.println("}");
    }

    private void generateReturnAnonymousClass(TypeModel model) {
        this.println("return new " + model.simpleName() + "() {");
        DslGenerator indent = this.indent();
        model.methods().forEach(keywordModel -> indent.generateMethod("public", (MethodModel)keywordModel));
        this.println("};");
    }

    private String parameters(MethodModel model) {
        List collect = model.parameters().stream().map(p -> p.type().fullName() + " " + p.name()).collect(Collectors.toList());
        if (this.useVarargs && !collect.isEmpty()) {
            collect.set(collect.size() - 1, ((String)collect.get(collect.size() - 1)).replace("[] ", "... "));
        }
        return String.join((CharSequence)", ", collect);
    }

    private String args(MethodModel model) {
        return model.parameters().stream().map(VarModel::name).collect(Collectors.joining(", "));
    }
}

