/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.processor;

import fluent.api.model.MethodModel;
import fluent.api.model.StatementModel;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.dsl.model.DslModelFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

final class Node
implements Supplier<List<MethodModel>> {
    private final Map<String, Node> nodes = new LinkedHashMap<String, Node>();
    private final MethodModel methodModel;

    private Node(MethodModel methodModel) {
        this.methodModel = methodModel;
    }

    private void traverse(TypeModel t, List<TypeModel> out) {
        if (t.isTypeVariable()) {
            out.add(t);
        } else {
            t.typeParameters().forEach(p -> this.traverse((TypeModel)p, out));
        }
    }

    private List<TypeModel> usedTypeParameters(List<VarModel> parameters) {
        ArrayList<TypeModel> out = new ArrayList<TypeModel>();
        parameters.stream().map(VarModel::type).forEach(t -> this.traverse((TypeModel)t, (List<TypeModel>)out));
        return out;
    }

    public Node(boolean isStatic, TypeModel typeModel, List<TypeModel> typeParameters, String packageName, String className, String methodName, List<VarModel> parameters, StatementModel ... bindingModel) {
        LinkedHashMap map = new LinkedHashMap();
        typeParameters.forEach(p -> map.put(p.fullName(), p));
        this.usedTypeParameters(parameters).forEach(t -> map.put(t.fullName(), t));
        ArrayList newParameters = new ArrayList(map.values());
        if (Objects.isNull(typeModel)) {
            typeModel = DslModelFactory.type(Collections.emptyList(), newParameters, (String)packageName, (String)className, (Supplier)this);
        }
        ArrayList methodTypeParameters = isStatic ? newParameters : newParameters.subList(typeParameters.size(), newParameters.size());
        this.methodModel = DslModelFactory.method(Collections.emptyList(), (boolean)isStatic, (boolean)true, methodTypeParameters, (TypeModel)typeModel, (String)methodName, parameters, (StatementModel[])bindingModel);
    }

    public Node add(TypeModel typeModel, String className, String methodName, List<VarModel> parameters, StatementModel[] bindingModel) {
        return this.nodes.computeIfAbsent(className, key -> new Node(false, typeModel, this.methodModel.returnType().typeParameters(), "", className, methodName, parameters, bindingModel));
    }

    @Override
    public List<MethodModel> get() {
        return this.nodes.values().stream().map(n -> n.methodModel).collect(Collectors.toList());
    }

    public MethodModel methodModel() {
        return this.methodModel;
    }
}

