/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.processor;

import fluent.api.model.AnnotationModel;
import fluent.api.model.StatementModel;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.dsl.Constant;
import fluent.dsl.Dsl;
import fluent.dsl.model.DslModel;
import fluent.dsl.model.DslModelFactory;
import fluent.dsl.processor.DslParserState;
import fluent.dsl.processor.Node;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;

public class DslParser {
    private final DslModelFactory factory;

    public DslParser(DslModelFactory factory) {
        this.factory = factory;
    }

    public DslModel parseModel(Element element) {
        TypeModel model = this.factory.type(element);
        Dsl dsl = element.getAnnotation(Dsl.class);
        String packageName = dsl.packageName().isEmpty() ? model.packageName() : dsl.packageName();
        String dslName = dsl.className().isEmpty() ? model.rawType().simpleName() + "Dsl" : dsl.className();
        VarModel source = this.factory.parameter(Collections.emptyList(), model, dsl.parameterName());
        Node node = new Node(true, null, model.typeParameters(), packageName, dslName, dsl.factoryMethod(), Collections.singletonList(source), new StatementModel[0]);
        DslModel dslModel = this.factory.dsl(node.methodModel(), dsl.delegateMethod());
        State prefix = this.start(dslModel, node);
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            prefix = this.annotationState(prefix, annotationMirror);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(element.getEnclosedElements())) {
            State state = prefix.method(executableElement.getSimpleName().toString());
            for (VariableElement variableElement : executableElement.getParameters()) {
                for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                    state = this.annotationState(state, annotationMirror);
                }
                state = state.parameter(variableElement);
            }
            for (AnnotationMirror annotationMirror : executableElement.getAnnotationMirrors()) {
                state = this.annotationState(state, annotationMirror);
            }
            state.bind(executableElement);
        }
        return dslModel;
    }

    private State annotationState(State prev, AnnotationMirror annotation) {
        Element element = annotation.getAnnotationType().asElement();
        String name = element.getSimpleName().toString();
        if (Objects.nonNull(element.getAnnotation(Constant.class))) {
            return prev.constant(name);
        }
        Dsl dsl = this.getDsl(element);
        if (Objects.nonNull(dsl)) {
            return prev.keyword(name, element.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.ANNOTATION_TYPE).map(e -> e.getSimpleName().toString()).collect(Collectors.toList()), dsl.useVarargs());
        }
        return prev.annotation(this.factory.annotation(annotation.toString()));
    }

    private Dsl getDsl(Element element) {
        Dsl dsl = element.getAnnotation(Dsl.class);
        if (Objects.nonNull(dsl)) {
            return dsl;
        }
        Element enclosingElement = element.getEnclosingElement();
        if (Objects.nonNull(enclosingElement)) {
            return this.getDsl(enclosingElement);
        }
        try {
            Element packageElement = (Element)element.getClass().getField("owner").get(element);
            if (Objects.nonNull(packageElement)) {
                return this.getDsl(packageElement);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        return null;
    }

    private State start(DslModel model, Node node) {
        DslParserState dslParserState = new DslParserState(this.factory, model, (VarModel)model.factory().parameters().get(0));
        dslParserState.getClass();
        return dslParserState.new DslParserState.InitialState(node);
    }

    public static interface State {
        public State annotation(AnnotationModel var1);

        public State keyword(String var1, List<String> var2, boolean var3);

        public State method(String var1);

        public State constant(String var1);

        public State parameter(VariableElement var1);

        public void bind(ExecutableElement var1);
    }
}

