/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.processor;

import fluent.dsl.Dsl;
import fluent.dsl.generator.DslGenerator;
import fluent.dsl.model.DslModel;
import fluent.dsl.model.DslModelFactory;
import fluent.dsl.model.TypeModelFactoryVisitor;
import fluent.dsl.processor.DslParser;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"fluent.dsl.Dsl"})
public class DslAnnotationProcessor
extends AbstractProcessor {
    private final Set<ElementKind> modelTypes = new HashSet<ElementKind>(Arrays.asList(ElementKind.INTERFACE, ElementKind.CLASS));

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Dsl.class)) {
            if (!this.modelTypes.contains((Object)element.getKind())) continue;
            this.process(element, new DslParser(new DslModelFactory(new TypeModelFactoryVisitor(this.processingEnv.getElementUtils(), this.processingEnv.getTypeUtils()))));
        }
        return true;
    }

    private void process(Element element, DslParser factory) {
        try {
            DslModel model = factory.parseModel(element);
            DslGenerator.generateFrom((Writer)this.processingEnv.getFiler().createSourceFile(model.type().rawType().fullName(), new Element[0]).openWriter(), (DslModel)model, (boolean)element.getAnnotation(Dsl.class).useVarargs());
        }
        catch (Throwable throwable) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unable to generate DSL for " + element + ": " + throwable, element);
        }
    }
}

