/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.processor;

import fluent.dsl.model.AnnotationModel;
import fluent.dsl.model.BaseModel;
import fluent.dsl.model.BindingModel;
import fluent.dsl.model.DslModel;
import fluent.dsl.model.DslUtils;
import fluent.dsl.model.KeywordModel;
import fluent.dsl.model.ParameterModel;
import fluent.dsl.model.TypeModel;
import fluent.dsl.processor.DslParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;

public class DslParserState {
    private final DslModel dsl;
    private final ParameterModel impl;

    public DslParserState(DslModel dsl, ParameterModel impl) {
        this.dsl = dsl;
        this.impl = impl;
    }

    public class DecideState
    extends KeywordState
    implements DslParser.State {
        private final TypeModel model;
        private final String methodName;

        public DecideState(TypeModel model, String name) {
            super(model, name, Collections.emptyList());
            this.model = model;
            this.methodName = name;
        }

        @Override
        public DslParser.State keyword(String name, List<String> aliases) {
            return new KeywordState(this.model, name, aliases);
        }

        @Override
        public DslParser.State constant(String name) {
            return this.keyword(this.methodName, Collections.emptyList()).constant(name);
        }

        @Override
        public DslParser.State parameter(VariableElement parameterModel) {
            return this.keyword(this.methodName, Collections.emptyList()).parameter(parameterModel);
        }
    }

    public class KeywordState
    implements DslParser.State {
        private final TypeModel model;
        private final String methodName;
        private final List<String> aliases;
        private final List<ParameterModel> parameters = new ArrayList<ParameterModel>();

        public KeywordState(TypeModel model, String name, List<String> aliases) {
            this.model = model;
            this.methodName = name;
            this.aliases = aliases;
        }

        @Override
        public DslParser.State annotation(AnnotationModel annotationModel) {
            return this;
        }

        @Override
        public DslParser.State keyword(String name, List<String> aliases) {
            return new KeywordState(this.finish(null), name, aliases);
        }

        @Override
        public DslParser.State method(String name) {
            return new DecideState(this.finish(null), name);
        }

        @Override
        public DslParser.State constant(String name) {
            this.parameters.add(DslParserState.this.dsl.addConstant(name));
            return this;
        }

        @Override
        public DslParser.State parameter(VariableElement parameterModel) {
            this.parameters.add(this.toModel(parameterModel));
            return this;
        }

        @Override
        public void bind(ExecutableElement method) {
            TypeModel returnTypeModel = new TypeModel(Collections.emptyList(), method.getReturnType().toString());
            KeywordModel body = new KeywordModel(Collections.emptyList(), returnTypeModel, method.getSimpleName().toString(), Collections.emptyList(), method.getParameters().stream().map(this::toModel).collect(Collectors.toList()), null);
            BindingModel binding = new BindingModel((BaseModel)(method.getModifiers().contains((Object)Modifier.STATIC) ? DslParserState.this.impl.type() : DslParserState.this.impl), body);
            this.finish(binding);
        }

        private TypeModel finish(BindingModel bindingModel) {
            return this.model.add(DslUtils.capitalize((String)this.methodName) + this.parameters.stream().map(p -> DslUtils.simpleName((String)p.type().name())).collect(Collectors.joining()), this.methodName, this.aliases, this.parameters, bindingModel).type();
        }

        private ParameterModel toModel(VariableElement parameter) {
            return new ParameterModel(Collections.emptyList(), new TypeModel(Collections.emptyList(), parameter.asType().toString()), parameter.getSimpleName().toString());
        }
    }

    public class InitialState
    implements DslParser.State {
        @Override
        public DslParser.State annotation(AnnotationModel annotationModel) {
            return this;
        }

        @Override
        public DslParser.State keyword(String name, List<String> aliases) {
            return new KeywordState((TypeModel)DslParserState.this.dsl, name, aliases);
        }

        @Override
        public DslParser.State method(String name) {
            return new DecideState((TypeModel)DslParserState.this.dsl, name);
        }

        @Override
        public DslParser.State constant(String name) {
            return this;
        }

        @Override
        public DslParser.State parameter(VariableElement parameterModel) {
            return this;
        }

        @Override
        public void bind(ExecutableElement method) {
        }
    }
}

