/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.processor;

import fluent.dsl.Constant;
import fluent.dsl.Dsl;
import fluent.dsl.model.AnnotationModel;
import fluent.dsl.model.DslModel;
import fluent.dsl.model.ParameterModel;
import fluent.dsl.model.TypeModel;
import fluent.dsl.processor.DslParserState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;

public class DslParser {
    private DslModel createModel(Element element) {
        Dsl dsl = element.getAnnotation(Dsl.class);
        String packageName = dsl.packageName().isEmpty() ? element.getEnclosingElement().toString() : dsl.packageName();
        String dslName = dsl.className().isEmpty() ? element.getSimpleName() + "Dsl" : dsl.className();
        ParameterModel source = new ParameterModel(Collections.emptyList(), new TypeModel(Collections.emptyList(), element.toString()), dsl.parameterName());
        return new DslModel(packageName, new ArrayList(), dslName, dsl.factoryMethod(), source, dsl.delegateMethod());
    }

    public DslModel parseModel(Element element) {
        DslModel model = this.createModel(element);
        State prefix = this.start(model);
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            prefix = this.annotationState(prefix, annotationMirror);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(element.getEnclosedElements())) {
            State state = prefix.method(executableElement.getSimpleName().toString());
            for (VariableElement variableElement : executableElement.getParameters()) {
                for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                    state = this.annotationState(state, annotationMirror);
                }
                state = state.parameter(variableElement);
            }
            for (AnnotationMirror annotationMirror : executableElement.getAnnotationMirrors()) {
                state = this.annotationState(state, annotationMirror);
            }
            state.bind(executableElement);
        }
        return model;
    }

    private State annotationState(State prev, AnnotationMirror annotation) {
        Element element = annotation.getAnnotationType().asElement();
        String name = element.getSimpleName().toString();
        if (Objects.nonNull(element.getAnnotation(Constant.class))) {
            return prev.constant(name);
        }
        if (this.isKeyword(element)) {
            return prev.keyword(name, element.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.ANNOTATION_TYPE).map(e -> e.getSimpleName().toString()).collect(Collectors.toList()));
        }
        return prev.annotation(new AnnotationModel(annotation.toString()));
    }

    private boolean isKeyword(Element element) {
        if (Objects.nonNull(element.getAnnotation(Dsl.class))) {
            return true;
        }
        Element enclosingElement = element.getEnclosingElement();
        if (Objects.nonNull(enclosingElement)) {
            return this.isKeyword(enclosingElement);
        }
        try {
            Element packageElement = (Element)element.getClass().getField("owner").get(element);
            if (Objects.nonNull(packageElement)) {
                return this.isKeyword(packageElement);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        return false;
    }

    private State start(DslModel model) {
        return new DslParserState(model, (ParameterModel)model.factory().parameters().get(0)).new DslParserState.InitialState();
    }

    public static interface State {
        public State annotation(AnnotationModel var1);

        public State keyword(String var1, List<String> var2);

        public State method(String var1);

        public State constant(String var1);

        public State parameter(VariableElement var1);

        public void bind(ExecutableElement var1);
    }
}

