/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.plugin.check;

import fluent.api.model.ClassModel;
import fluent.api.model.MethodModel;
import fluent.api.model.ModelFactory;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.dsl.Dsl;
import fluent.dsl.plugin.DslUtils;
import fluent.dsl.processor.DslAnnotationProcessorPlugin;
import fluent.dsl.processor.DslAnnotationProcessorPluginFactory;
import fluent.validation.Check;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;

public class CheckDslPlugin
implements DslAnnotationProcessorPlugin {
    private final ModelFactory factory;
    private final Map<String, TypeModel<?>> boxedTypes = new HashMap();

    public CheckDslPlugin(ModelFactory factory) {
        this.factory = factory;
        this.boxedTypes.put("int", (TypeModel<?>)factory.classModel("java.lang", "Integer"));
        this.boxedTypes.put("boolean", (TypeModel<?>)factory.classModel("java.lang", "Boolean"));
        this.boxedTypes.put("long", (TypeModel<?>)factory.classModel("java.lang", "Long"));
    }

    public boolean isFor(Element element) {
        return element instanceof VariableElement && this.factory.parameter((VariableElement)element).type().rawType().fullName().equals(Check.class.getCanonicalName());
    }

    public TypeModel<?> process(Element element, Dsl dsl) {
        VarModel v = this.factory.parameter((VariableElement)element);
        TypeModel typeModel = (TypeModel)v.type().typeParameters().get(0);
        String packageName = DslUtils.override((String)dsl.packageName(), (String)typeModel.packageName());
        String className = DslUtils.override((String)dsl.className(), (String)(typeModel.rawType().simpleName() + "With"));
        ClassModel fluentCheck = this.factory.classModel(packageName, className);
        for (MethodModel method : typeModel.methods()) {
            if (!this.isGetter(method)) continue;
            this.processGetter(fluentCheck, method);
        }
        return fluentCheck;
    }

    private boolean isGetter(MethodModel method) {
        return method.name().startsWith("get") && method.parameters().isEmpty();
    }

    private void processGetter(ClassModel fluentCheck, MethodModel method) {
        String name = method.name();
    }

    private TypeModel<?> boxed(TypeModel<?> type) {
        return this.boxedTypes.getOrDefault(type.fullName(), type);
    }

    public static class Factory
    implements DslAnnotationProcessorPluginFactory {
        public DslAnnotationProcessorPlugin createPlugin(ModelFactory factory) {
            return new CheckDslPlugin(factory);
        }
    }
}

