/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.model;

import fluent.api.model.AnnotationModel;
import fluent.api.model.MethodModel;
import fluent.api.model.StatementModel;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.api.model.lazy.LazyAnnotationModel;
import fluent.api.model.lazy.LazyMethodModel;
import fluent.api.model.lazy.LazyTypeModel;
import fluent.api.model.lazy.LazyVarModel;
import fluent.dsl.model.DslModel;
import fluent.dsl.model.TypeModelFactoryVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public class DslModelFactory {
    private final TypeModelFactoryVisitor visitor;

    public DslModelFactory(TypeModelFactoryVisitor visitor) {
        this.visitor = visitor;
    }

    public VarModel parameter(List<AnnotationModel> emptyList, TypeModel type, String name) {
        return new LazyVarModel(() -> emptyList, false, true, type, name);
    }

    public static MethodModel method(List<AnnotationModel> annotations, boolean isStatic, boolean isPublic, List<TypeModel> typeParameters, TypeModel returnType, String name, List<VarModel> parameters, StatementModel ... body) {
        return new LazyMethodModel(() -> annotations, isStatic, isPublic, () -> typeParameters, returnType, name, () -> parameters, () -> Arrays.asList(body));
    }

    public AnnotationModel annotation(String type) {
        return new LazyAnnotationModel(Collections::emptyList, true, true, null);
    }

    public TypeModel type(List<AnnotationModel> annotations, String packageName, String simpleName) {
        return new LazyTypeModel(() -> annotations, true, true, Collections::emptyList, packageName, simpleName, packageName.isEmpty() ? simpleName : packageName + "." + simpleName, false, Collections::emptyList, Collections::emptyList);
    }

    public TypeModel type(Element element) {
        return this.visitor.visit(element.asType(), element);
    }

    public VarModel parameter(VariableElement element) {
        return this.visitor.parameter(element);
    }

    public MethodModel method(ExecutableElement element) {
        return this.visitor.method(element);
    }

    public static TypeModel type(List<AnnotationModel> annotations, List<TypeModel> typeParameters, String packageName, String simpleName, Supplier<List<MethodModel>> methodSupplier) {
        LazyTypeModel raw = new LazyTypeModel(() -> annotations, true, true, Collections::emptyList, packageName, simpleName, packageName.isEmpty() ? simpleName : packageName + "." + simpleName, false, methodSupplier, Collections::emptyList);
        if (typeParameters.isEmpty()) {
            return raw;
        }
        String collect = typeParameters.stream().map(TypeModel::fullName).collect(Collectors.joining(", ", "<", ">"));
        return new LazyTypeModel(() -> annotations, true, true, () -> typeParameters, packageName, simpleName + collect, raw.fullName() + collect, false, () -> DslModelFactory.lambda$type$9((TypeModel)raw), null, methodSupplier, Collections::emptyList);
    }

    public DslModel dsl(MethodModel factory, String delegate) {
        return new DslModel(factory, delegate);
    }

    public StatementModel statementModel(final VarModel target, final MethodModel method) {
        return new StatementModel(){

            public String toString() {
                return (method.returnsValue() ? "return " : "") + (method.isStatic() ? target.type().fullName() : target.name()) + "." + method.name() + "(" + method.parameters().stream().map(VarModel::name).collect(Collectors.joining(", ")) + ");";
            }
        };
    }

    private static /* synthetic */ TypeModel lambda$type$9(TypeModel raw) {
        return raw;
    }
}

