/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.model;

import fluent.api.model.MethodModel;
import fluent.api.model.StatementModel;
import fluent.api.model.TypeModel;
import fluent.api.model.VarModel;
import fluent.dsl.model.DslModelFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class DslModel {
    private final TypeModel type;
    private final MethodModel factory;
    private final MethodModel delegate;
    private final Map<String, VarModel> constants = new LinkedHashMap<String, VarModel>();

    public DslModel(MethodModel factory, String delegate) {
        this.factory = factory;
        this.type = factory.returnType();
        this.delegate = DslModelFactory.method(Collections.emptyList(), true, true, Collections.emptyList(), this.type, delegate, Collections.emptyList(), new StatementModel[0]);
    }

    public TypeModel type() {
        return this.type;
    }

    public MethodModel factory() {
        return this.factory;
    }

    public MethodModel delegate() {
        return this.delegate;
    }

    public String toString() {
        return this.type.fullName();
    }

    public Collection<VarModel> constants() {
        return this.constants.values();
    }

    public VarModel addConstant(VarModel constant) {
        return this.constants.computeIfAbsent(constant.name(), key -> constant);
    }
}

