/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.model;

import fluent.dsl.model.AnnotationModel;
import fluent.dsl.model.DslUtils;
import fluent.dsl.model.KeywordModel;
import fluent.dsl.model.ParameterModel;
import fluent.dsl.model.TypeModel;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DslModel
extends TypeModel {
    private final String packageName;
    private final KeywordModel factory;
    private final KeywordModel delegate;
    private final Map<String, ParameterModel> constants = new LinkedHashMap<String, ParameterModel>();

    public DslModel(String packageName, List<AnnotationModel> annotations, String name, String factory, ParameterModel source, String delegate) {
        super(annotations, name);
        this.packageName = packageName;
        this.factory = new KeywordModel(Collections.emptyList(), this, factory, Collections.emptyList(), Collections.singletonList(source), null, false);
        this.delegate = new KeywordModel(Collections.emptyList(), this, delegate, Collections.emptyList(), Collections.emptyList(), null, false);
    }

    public String packageName() {
        return this.packageName;
    }

    public KeywordModel factory() {
        return this.factory;
    }

    public KeywordModel delegate() {
        return this.delegate;
    }

    @Override
    public String toString() {
        return this.packageName + "." + this.name();
    }

    public ParameterModel addConstant(String name) {
        return this.constants.computeIfAbsent(name, key -> new ParameterModel(Collections.emptyList(), new TypeModel(Collections.emptyList(), DslUtils.capitalize(name)), name));
    }

    public Collection<ParameterModel> constants() {
        return this.constants.values();
    }
}

