/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.generator;

import fluent.dsl.model.BaseModel;
import fluent.dsl.model.BindingModel;
import fluent.dsl.model.DslModel;
import fluent.dsl.model.KeywordModel;
import fluent.dsl.model.ParameterModel;
import fluent.dsl.model.TypeModel;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.stream.Collectors;

public class DslGenerator {
    private static final String tab = "\t";
    private final PrintWriter source;
    private final String prefix;
    private final boolean useVarargs;

    private DslGenerator(PrintWriter source, String prefix, boolean useVarargs) {
        this.source = source;
        this.prefix = prefix;
        this.useVarargs = useVarargs;
    }

    private DslGenerator indent() {
        return new DslGenerator(this.source, this.prefix + tab, this.useVarargs);
    }

    private void println(String line) {
        this.source.println(this.prefix + line);
    }

    private void println() {
        this.source.println();
    }

    public static void generateFrom(Writer writer, DslModel model, boolean useVarargs) {
        try (PrintWriter source = new PrintWriter(writer);){
            new DslGenerator(source, "", useVarargs).generateDsl(model);
        }
    }

    private void generateDsl(DslModel model) {
        DslGenerator nested = this.indent();
        this.println("package " + model.packageName() + ";");
        this.println();
        this.println("import fluent.api.Start;");
        this.println("import fluent.api.End;");
        this.println();
        this.println();
        this.println("public interface " + model.name() + "{");
        model.constants().forEach(nested::generateConstant);
        this.println();
        nested.generateMethod("static", model.factory());
        this.println();
        nested.generateInterfaceContent(model);
        this.println();
        nested.generateDelegate(model);
        this.println();
        model.constants().forEach(nested::generateConstantClass);
        this.println("}");
    }

    private void generateConstant(ParameterModel constant) {
        this.println("public static final " + constant.type().name() + " " + constant.name() + " = new " + constant.type().name() + "();");
    }

    private void generateConstantClass(ParameterModel constant) {
        this.println();
        this.println("public static final class " + constant.type().name() + "{");
        this.indent().println("private " + constant.type().name() + "() {}");
        this.println("}");
    }

    private void generateDelegate(DslModel model) {
        this.println("public interface Delegate extends " + model.name() + " {");
        DslGenerator indent = this.indent();
        indent.generateSignature(model.delegate());
        model.keywords().forEach(keyword -> indent.generateDelegateMethod((KeywordModel)keyword, model.delegate()));
        this.println("}");
    }

    private void generateDelegateMethod(KeywordModel model, KeywordModel delegate) {
        this.println("default " + model.type() + " " + model.name() + "(" + this.parameters(model) + ") {");
        this.indent().println(this.returnType(model) + delegate.name() + "()." + model.name() + "(" + this.args(model) + ");");
        this.println("}");
    }

    private void generateInterfaceContent(TypeModel model) {
        model.keywords().forEach(this::generateSignature);
        model.keywords().stream().filter(kw -> !kw.hasBinding()).map(KeywordModel::type).forEach(this::generateInterface);
    }

    private void generateInterface(TypeModel model) {
        this.println();
        this.println("public interface " + model.name() + " {");
        this.indent().generateInterfaceContent(model);
        this.println("}");
    }

    private void generateSignature(KeywordModel model) {
        this.println((model.hasBinding() ? "@End " : "@Start(\"Unterminated sentence.\") ") + model.type() + " " + model.name() + "(" + this.parameters(model) + ");");
        model.aliases().forEach(alias -> {
            this.println("default " + model.type() + " " + alias + "(" + this.parameters(model) + ") {");
            this.indent().println(this.returnType(model) + model.name() + "(" + this.args(model) + ");");
            this.println("}");
        });
    }

    private String returnType(KeywordModel model) {
        return "void".equals(model.type().name()) ? "" : "return ";
    }

    private void generateMethod(String modifiers, KeywordModel model) {
        this.println(modifiers + " " + model.type().name() + " " + model.name() + "(" + this.parameters(model) + ") {");
        if (model.hasBinding()) {
            BindingModel binding = model.binding();
            this.indent().println(this.returnType(binding.method()) + binding.target().name() + "." + binding.method().name() + "(" + this.args(binding.method()) + ");");
        } else {
            this.indent().generateReturnAnonymousClass(model.type());
        }
        this.println("}");
    }

    private void generateReturnAnonymousClass(TypeModel model) {
        this.println("return new " + model.name() + "() {");
        DslGenerator indent = this.indent();
        model.keywords().forEach(keywordModel -> indent.generateMethod("public", (KeywordModel)keywordModel));
        this.println("};");
    }

    private String parameters(KeywordModel model) {
        List collect = model.parameters().stream().map(p -> p.type().name() + " " + p.name()).collect(Collectors.toList());
        if (this.useVarargs && !collect.isEmpty()) {
            collect.set(collect.size() - 1, ((String)collect.get(collect.size() - 1)).replace("[] ", "... "));
        }
        return String.join((CharSequence)", ", collect);
    }

    private String args(KeywordModel model) {
        return model.parameters().stream().map(BaseModel::name).collect(Collectors.joining(", "));
    }
}

