/*
 * Decompiled with CFR 0.152.
 */
package com.appunite.firebasetestlabplugin.cloud;

import com.appunite.firebasetestlabplugin.cloud.FirebaseTestLabProcessCreator;
import com.appunite.firebasetestlabplugin.cloud.ProcessData;
import com.appunite.firebasetestlabplugin.cloud.TestType;
import com.appunite.firebasetestlabplugin.model.Device;
import com.appunite.firebasetestlabplugin.model.ScreenOrientation;
import com.appunite.firebasetestlabplugin.model.TestResults;
import com.appunite.firebasetestlabplugin.utils.CloudUtilsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/appunite/firebasetestlabplugin/cloud/FirebaseTestLabProcessCreator;", "", "()V", "resultMessageMap", "", "", "", "callFirebaseTestLab", "Lcom/appunite/firebasetestlabplugin/model/TestResults;", "processData", "Lcom/appunite/firebasetestlabplugin/cloud/ProcessData;", "createProcess", "Ljava/lang/ProcessBuilder;", "setupEnvironmentVariables", "Lkotlin/sequences/Sequence;", "device", "Lcom/appunite/firebasetestlabplugin/model/Device;", "shardIndex", "plugin"})
public final class FirebaseTestLabProcessCreator {
    private static final Map<Integer, String> resultMessageMap;
    public static final FirebaseTestLabProcessCreator INSTANCE;

    @NotNull
    public final TestResults callFirebaseTestLab(@NotNull ProcessData processData) {
        Intrinsics.checkParameterIsNotNull((Object)processData, (String)"processData");
        Process process = this.createProcess(processData).start();
        Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"createProcess(processData).start()");
        Process process2 = process;
        Object object = process2;
        Process it = object;
        boolean bl = false;
        InputStream inputStream = it.getErrorStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"it.errorStream");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Closeable closeable = inputStream2;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        int n = 8192;
        TextStreamsKt.forEachLine((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)), (Function1)callFirebaseTestLab.resultCode.1.1.INSTANCE);
        InputStream inputStream3 = it.getInputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream3, (String)"it.inputStream");
        inputStream2 = inputStream3;
        charset = Charsets.UTF_8;
        closeable = inputStream2;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        n = 8192;
        TextStreamsKt.forEachLine((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)), (Function1)callFirebaseTestLab.resultCode.1.2.INSTANCE);
        int resultCode2 = process2.waitFor();
        object = resultMessageMap;
        Integer n2 = resultCode2;
        boolean bl2 = resultCode2 == 0;
        Object object2 = object.get(n2);
        if (object2 == null) {
            boolean bl3 = false;
            object2 = "Unknown error with code: " + resultCode2;
        }
        Object v = object2;
        String string = (String)v;
        boolean bl4 = bl2;
        return new TestResults(bl4, string);
    }

    /*
     * WARNING - void declaration
     */
    private final ProcessBuilder createProcess(ProcessData processData) {
        String string;
        Sequence sequence;
        Device device;
        block19: {
            block18: {
                String string2;
                Sequence sequence2;
                Object it;
                Sequence sequence3;
                Object object;
                block17: {
                    block16: {
                        String string3;
                        Sequence sequence4;
                        Sequence sequence5;
                        block15: {
                            block14: {
                                Sequence sequence6;
                                Collection<String> collection;
                                void $receiver$iv$iv;
                                void $receiver$iv;
                                device = processData.getDevice();
                                Sequence sequence7 = new String[11];
                                sequence7[0] = processData.getSdk().getGcloud().getAbsolutePath();
                                sequence7[1] = "firebase";
                                sequence7[2] = "test";
                                sequence7[3] = "android";
                                sequence7[4] = "run";
                                sequence7[5] = "--format=json";
                                sequence7[6] = "--device-ids=" + CloudUtilsKt.joinArgs(device.getDeviceIds());
                                sequence7[7] = "--app=" + processData.getApk();
                                sequence7[8] = "--locales=" + CloudUtilsKt.joinArgs(device.getLocales());
                                sequence7[9] = "--os-version-ids=" + CloudUtilsKt.joinArgs(device.getAndroidApiLevels());
                                object = device.getScreenOrientations();
                                StringBuilder stringBuilder = new StringBuilder().append("--orientations=");
                                int n = 10;
                                sequence5 = sequence7;
                                sequence3 = sequence7;
                                void var4_10 = $receiver$iv;
                                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                                for (Object item$iv$iv : $receiver$iv$iv) {
                                    void orientation;
                                    ScreenOrientation screenOrientation = (ScreenOrientation)((Object)item$iv$iv);
                                    collection = destination$iv$iv;
                                    boolean bl = false;
                                    String string4 = orientation.getGcloudName$plugin();
                                    collection.add(string4);
                                }
                                collection = (List)destination$iv$iv;
                                sequence5[n] = stringBuilder.append(CloudUtilsKt.joinArgs(collection)).toString();
                                Sequence sequence8 = SequencesKt.sequenceOf((Object[])sequence3);
                                object = processData.getTestType();
                                if (Intrinsics.areEqual((Object)object, (Object)TestType.Robo.INSTANCE)) {
                                    sequence6 = SequencesKt.sequenceOf((Object[])new String[]{"--type=robo"});
                                } else if (object instanceof TestType.Instrumentation) {
                                    sequence6 = SequencesKt.sequenceOf((Object[])new String[]{"--type=instrumentation", "--test=" + ((TestType.Instrumentation)processData.getTestType()).getTestApk()});
                                } else {
                                    throw new NoWhenBranchMatchedException();
                                }
                                sequence4 = SequencesKt.plus((Sequence)sequence8, (Sequence)sequence6);
                                string3 = processData.getGCloudBucketName();
                                if (string3 == null) break block14;
                                object = string3;
                                sequence3 = sequence4;
                                it = object;
                                boolean bl = false;
                                sequence5 = SequencesKt.sequenceOf((Object[])new String[]{"--results-bucket=" + (String)it});
                                sequence4 = sequence3;
                                string3 = sequence5;
                                if (string3 != null) break block15;
                            }
                            string3 = SequencesKt.sequenceOf((Object[])new String[0]);
                        }
                        sequence2 = SequencesKt.plus((Sequence)sequence4, (Sequence)string3);
                        string2 = processData.getGCloudDirectory();
                        if (string2 == null) break block16;
                        object = string2;
                        sequence3 = sequence2;
                        it = object;
                        boolean bl = false;
                        sequence5 = SequencesKt.sequenceOf((Object[])new String[]{"--results-dir=" + (String)it});
                        sequence2 = sequence3;
                        string2 = sequence5;
                        if (string2 != null) break block17;
                    }
                    string2 = SequencesKt.sequenceOf((Object[])new String[0]);
                }
                object = device.getTestTargets();
                sequence3 = SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)sequence2, (Sequence)string2), (Sequence)(device.isUseOrchestrator() ? SequencesKt.sequenceOf((Object[])new String[]{"--use-orchestrator"}) : SequencesKt.sequenceOf((Object[])new String[0]))), this.setupEnvironmentVariables(device, processData.getShardIndex()));
                boolean bl = !object.isEmpty();
                sequence = SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)sequence3, (Sequence)(bl ? SequencesKt.sequenceOf((Object[])new String[]{"--test-targets=" + CollectionsKt.joinToString$default((Iterable)device.getTestTargets(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)}) : SequencesKt.sequenceOf((Object[])new String[0]))), (Iterable)device.getCustomParamsForGCloudTool());
                string = device.getTestRunnerClass();
                if (string == null) break block18;
                object = string;
                sequence3 = sequence;
                it = object;
                boolean bl2 = false;
                Sequence sequence9 = SequencesKt.sequenceOf((Object[])new String[]{"--test-runner-class=" + (String)it});
                sequence = sequence3;
                string = sequence9;
                if (string != null) break block19;
            }
            string = SequencesKt.sequenceOf((Object[])new String[0]);
        }
        List list = SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)sequence, (Sequence)string), (Sequence)(device.getTimeout() > 0L ? SequencesKt.sequenceOf((Object[])new String[]{"--timeout=" + device.getTimeout() + 's'}) : SequencesKt.sequenceOf((Object[])new String[0]))));
        return new ProcessBuilder(list);
    }

    private final Sequence<String> setupEnvironmentVariables(Device device, int shardIndex) {
        Sequence sequence;
        Collection collection = device.getEnvironmentVariables();
        if (!collection.isEmpty() || device.getNumShards() > 0) {
            Object[] objectArray;
            collection = device.getEnvironmentVariables();
            StringBuilder stringBuilder = new StringBuilder().append("--environment-variables=");
            int n = 0;
            Object[] objectArray2 = objectArray = new String[1];
            boolean bl = !collection.isEmpty();
            collection = device.getEnvironmentVariables();
            stringBuilder = stringBuilder.append(bl ? CollectionsKt.joinToString$default((Iterable)device.getEnvironmentVariables(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) : "");
            bl = !collection.isEmpty();
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder.append(bl && device.getNumShards() > 0 ? "," : "").append(device.getNumShards() > 0 ? "numShards=" + device.getNumShards() + ",shardIndex=" + shardIndex : "").toString(), (String)"StringBuilder()\n        \u2026              .toString()");
            sequence = SequencesKt.sequenceOf((Object[])objectArray2);
        } else {
            sequence = SequencesKt.sequenceOf((Object[])new String[0]);
        }
        return sequence;
    }

    private FirebaseTestLabProcessCreator() {
    }

    static {
        FirebaseTestLabProcessCreator firebaseTestLabProcessCreator;
        INSTANCE = firebaseTestLabProcessCreator = new FirebaseTestLabProcessCreator();
        resultMessageMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)0, (Object)"All test executions passed."), TuplesKt.to((Object)1, (Object)"A general failure occurred. Possible causes include: a filename that does not exist, or an HTTP/network error."), TuplesKt.to((Object)2, (Object)"Testing exited because unknown commands or arguments were provided."), TuplesKt.to((Object)10, (Object)"One or more test cases (tested classes or class methods) within a test execution did not pass."), TuplesKt.to((Object)15, (Object)"Firebase Test Lab for Android could not determine if the test matrix passed or failed because of an unexpected error."), TuplesKt.to((Object)18, (Object)"The test environment for this test execution is not supported because of incompatible test dimensions. This error might occur if the selected Android API level is not supported by the selected device type."), TuplesKt.to((Object)19, (Object)"The test matrix was canceled by the user."), TuplesKt.to((Object)20, (Object)"A test infrastructure error occurred.")});
    }
}

